package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ResourceClassParameters defines resource requests for a ResourceClass in an in-tree format understood by Kubernetes. */
final case class ResourceClassParameters(
  vendorParameters : Option[Seq[io.k8s.api.resource.v1alpha2.VendorParameters]] = None,
  generatedFrom : Option[io.k8s.api.resource.v1alpha2.ResourceClassParametersReference] = None,
  filters : Option[Seq[io.k8s.api.resource.v1alpha2.ResourceFilter]] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("resource.k8s.io", "ResourceClassParameters", "v1alpha2")


  /** Returns a new data with vendorParameters set to new value */
  def withVendorParameters(value: Seq[io.k8s.api.resource.v1alpha2.VendorParameters]) : ResourceClassParameters = copy(vendorParameters = Some(value))
  /** Appends new values to vendorParameters */
  def addVendorParameters(newValues: io.k8s.api.resource.v1alpha2.VendorParameters*) : ResourceClassParameters = copy(vendorParameters = Some(vendorParameters.fold(newValues)(_ ++ newValues)))
  /** if vendorParameters has a value, transforms to the result of function*/
  def mapVendorParameters(f: Seq[io.k8s.api.resource.v1alpha2.VendorParameters] => Seq[io.k8s.api.resource.v1alpha2.VendorParameters]) : ResourceClassParameters = copy(vendorParameters = vendorParameters.map(f))

  /** Returns a new data with generatedFrom set to new value */
  def withGeneratedFrom(value: io.k8s.api.resource.v1alpha2.ResourceClassParametersReference) : ResourceClassParameters = copy(generatedFrom = Some(value))
  /** if generatedFrom has a value, transforms to the result of function*/
  def mapGeneratedFrom(f: io.k8s.api.resource.v1alpha2.ResourceClassParametersReference => io.k8s.api.resource.v1alpha2.ResourceClassParametersReference) : ResourceClassParameters = copy(generatedFrom = generatedFrom.map(f))

  /** Returns a new data with filters set to new value */
  def withFilters(value: Seq[io.k8s.api.resource.v1alpha2.ResourceFilter]) : ResourceClassParameters = copy(filters = Some(value))
  /** Appends new values to filters */
  def addFilters(newValues: io.k8s.api.resource.v1alpha2.ResourceFilter*) : ResourceClassParameters = copy(filters = Some(filters.fold(newValues)(_ ++ newValues)))
  /** if filters has a value, transforms to the result of function*/
  def mapFilters(f: Seq[io.k8s.api.resource.v1alpha2.ResourceFilter] => Seq[io.k8s.api.resource.v1alpha2.ResourceFilter]) : ResourceClassParameters = copy(filters = filters.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceClassParameters = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceClassParameters = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ResourceClassParameters.encoder.apply(this)
}

object ResourceClassParameters {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.ResourceClassParameters] = new Encoder[io.k8s.api.resource.v1alpha2.ResourceClassParameters] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.ResourceClassParameters) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("vendorParameters", o.vendorParameters)
            .write("generatedFrom", o.generatedFrom)
            .write("filters", o.filters)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClassParameters] = new Decoder[ResourceClassParameters] {
      def apply[T : Reader](t: T): Either[String, ResourceClassParameters] = for {
          obj <- ObjectReader(t)
          vendorParameters <- obj.readOpt[Seq[io.k8s.api.resource.v1alpha2.VendorParameters]]("vendorParameters")
          generatedFrom <- obj.readOpt[io.k8s.api.resource.v1alpha2.ResourceClassParametersReference]("generatedFrom")
          filters <- obj.readOpt[Seq[io.k8s.api.resource.v1alpha2.ResourceFilter]]("filters")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield ResourceClassParameters (
          vendorParameters = vendorParameters,
          generatedFrom = generatedFrom,
          filters = filters,
          metadata = metadata
        )
    }
}

