package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** NamedResourcesRequest is used in ResourceRequestModel. */
final case class NamedResourcesRequest(
  selector : String
) {

  /** Returns a new data with selector set to new value */
  def withSelector(value: String) : NamedResourcesRequest = copy(selector = value)
  /** transforms selector to result of function */
  def mapSelector(f: String => String) : NamedResourcesRequest = copy(selector = f(selector))
}

object NamedResourcesRequest {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.NamedResourcesRequest] = new Encoder[io.k8s.api.resource.v1alpha2.NamedResourcesRequest] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.NamedResourcesRequest) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("selector", o.selector)
            .build
        }
    }

    implicit val decoder: Decoder[NamedResourcesRequest] = new Decoder[NamedResourcesRequest] {
      def apply[T : Reader](t: T): Either[String, NamedResourcesRequest] = for {
          obj <- ObjectReader(t)
          selector <- obj.read[String]("selector")
      } yield NamedResourcesRequest (
          selector = selector
        )
    }
}

