package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** NamedResourcesAllocationResult is used in AllocationResultModel. */
final case class NamedResourcesAllocationResult(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : NamedResourcesAllocationResult = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : NamedResourcesAllocationResult = copy(name = f(name))
}

object NamedResourcesAllocationResult {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.NamedResourcesAllocationResult] = new Encoder[io.k8s.api.resource.v1alpha2.NamedResourcesAllocationResult] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.NamedResourcesAllocationResult) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .build
        }
    }

    implicit val decoder: Decoder[NamedResourcesAllocationResult] = new Decoder[NamedResourcesAllocationResult] {
      def apply[T : Reader](t: T): Either[String, NamedResourcesAllocationResult] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
      } yield NamedResourcesAllocationResult (
          name = name
        )
    }
}

