package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** NodeRuntimeHandler is a set of runtime handler information. */
final case class NodeRuntimeHandler(
  features : Option[io.k8s.api.core.v1.NodeRuntimeHandlerFeatures] = None,
  name : Option[String] = None
) {

  /** Returns a new data with features set to new value */
  def withFeatures(value: io.k8s.api.core.v1.NodeRuntimeHandlerFeatures) : NodeRuntimeHandler = copy(features = Some(value))
  /** if features has a value, transforms to the result of function*/
  def mapFeatures(f: io.k8s.api.core.v1.NodeRuntimeHandlerFeatures => io.k8s.api.core.v1.NodeRuntimeHandlerFeatures) : NodeRuntimeHandler = copy(features = features.map(f))

  /** Returns a new data with name set to new value */
  def withName(value: String) : NodeRuntimeHandler = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : NodeRuntimeHandler = copy(name = name.map(f))
}

object NodeRuntimeHandler {

    implicit val encoder : Encoder[io.k8s.api.core.v1.NodeRuntimeHandler] = new Encoder[io.k8s.api.core.v1.NodeRuntimeHandler] {
        def apply[T : Builder](o: io.k8s.api.core.v1.NodeRuntimeHandler) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("features", o.features)
            .write("name", o.name)
            .build
        }
    }

    implicit val decoder: Decoder[NodeRuntimeHandler] = new Decoder[NodeRuntimeHandler] {
      def apply[T : Reader](t: T): Either[String, NodeRuntimeHandler] = for {
          obj <- ObjectReader(t)
          features <- obj.readOpt[io.k8s.api.core.v1.NodeRuntimeHandlerFeatures]("features")
          name <- obj.readOpt[String]("name")
      } yield NodeRuntimeHandler (
          features = features,
          name = name
        )
    }
}

