package io.k8s.api.storage.v1

import dev.hnaderi.k8s.utils._

/** CSINodeSpec holds information about the specification of all CSI drivers installed on a node */
final case class CSINodeSpec(
  drivers : Seq[io.k8s.api.storage.v1.CSINodeDriver]
) {

  /** Returns a new data with drivers set to new value */
  def withDrivers(value: Seq[io.k8s.api.storage.v1.CSINodeDriver]) : CSINodeSpec = copy(drivers = value)
  /** Appends new values to drivers */
  def addDrivers(newValues: io.k8s.api.storage.v1.CSINodeDriver*) : CSINodeSpec = copy(drivers = drivers ++ newValues)
  /** transforms drivers to result of function */
  def mapDrivers(f: Seq[io.k8s.api.storage.v1.CSINodeDriver] => Seq[io.k8s.api.storage.v1.CSINodeDriver]) : CSINodeSpec = copy(drivers = f(drivers))
}

object CSINodeSpec {

    implicit val encoder : Encoder[io.k8s.api.storage.v1.CSINodeSpec] = new Encoder[io.k8s.api.storage.v1.CSINodeSpec] {
        def apply[T : Builder](o: io.k8s.api.storage.v1.CSINodeSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("drivers", o.drivers)
            .build
        }
    }

    implicit val decoder: Decoder[CSINodeSpec] = new Decoder[CSINodeSpec] {
      def apply[T : Reader](t: T): Either[String, CSINodeSpec] = for {
          obj <- ObjectReader(t)
          drivers <- obj.read[Seq[io.k8s.api.storage.v1.CSINodeDriver]]("drivers")
      } yield CSINodeSpec (
          drivers = drivers
        )
    }
}

