package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** NamedResourcesIntSlice contains a slice of 64-bit integers. */
final case class NamedResourcesIntSlice(
  ints : Seq[Long]
) {

  /** Returns a new data with ints set to new value */
  def withInts(value: Seq[Long]) : NamedResourcesIntSlice = copy(ints = value)
  /** Appends new values to ints */
  def addInts(newValues: Long*) : NamedResourcesIntSlice = copy(ints = ints ++ newValues)
  /** transforms ints to result of function */
  def mapInts(f: Seq[Long] => Seq[Long]) : NamedResourcesIntSlice = copy(ints = f(ints))
}

object NamedResourcesIntSlice {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.NamedResourcesIntSlice] = new Encoder[io.k8s.api.resource.v1alpha2.NamedResourcesIntSlice] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.NamedResourcesIntSlice) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("ints", o.ints)
            .build
        }
    }

    implicit val decoder: Decoder[NamedResourcesIntSlice] = new Decoder[NamedResourcesIntSlice] {
      def apply[T : Reader](t: T): Either[String, NamedResourcesIntSlice] = for {
          obj <- ObjectReader(t)
          ints <- obj.read[Seq[Long]]("ints")
      } yield NamedResourcesIntSlice (
          ints = ints
        )
    }
}

