package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** NamedResourcesAttribute is a combination of an attribute name and its value. */
final case class NamedResourcesAttribute(
  name : String,
  quantity : Option[io.k8s.apimachinery.pkg.api.resource.Quantity] = None,
  stringSlice : Option[io.k8s.api.resource.v1alpha2.NamedResourcesStringSlice] = None,
  string : Option[String] = None,
  version : Option[String] = None,
  bool : Option[Boolean] = None,
  intSlice : Option[io.k8s.api.resource.v1alpha2.NamedResourcesIntSlice] = None,
  int : Option[Long] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : NamedResourcesAttribute = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : NamedResourcesAttribute = copy(name = f(name))

  /** Returns a new data with quantity set to new value */
  def withQuantity(value: io.k8s.apimachinery.pkg.api.resource.Quantity) : NamedResourcesAttribute = copy(quantity = Some(value))
  /** if quantity has a value, transforms to the result of function*/
  def mapQuantity(f: io.k8s.apimachinery.pkg.api.resource.Quantity => io.k8s.apimachinery.pkg.api.resource.Quantity) : NamedResourcesAttribute = copy(quantity = quantity.map(f))

  /** Returns a new data with stringSlice set to new value */
  def withStringSlice(value: io.k8s.api.resource.v1alpha2.NamedResourcesStringSlice) : NamedResourcesAttribute = copy(stringSlice = Some(value))
  /** if stringSlice has a value, transforms to the result of function*/
  def mapStringSlice(f: io.k8s.api.resource.v1alpha2.NamedResourcesStringSlice => io.k8s.api.resource.v1alpha2.NamedResourcesStringSlice) : NamedResourcesAttribute = copy(stringSlice = stringSlice.map(f))

  /** Returns a new data with string set to new value */
  def withString(value: String) : NamedResourcesAttribute = copy(string = Some(value))
  /** if string has a value, transforms to the result of function*/
  def mapString(f: String => String) : NamedResourcesAttribute = copy(string = string.map(f))

  /** Returns a new data with version set to new value */
  def withVersion(value: String) : NamedResourcesAttribute = copy(version = Some(value))
  /** if version has a value, transforms to the result of function*/
  def mapVersion(f: String => String) : NamedResourcesAttribute = copy(version = version.map(f))

  /** Returns a new data with bool set to new value */
  def withBool(value: Boolean) : NamedResourcesAttribute = copy(bool = Some(value))
  /** if bool has a value, transforms to the result of function*/
  def mapBool(f: Boolean => Boolean) : NamedResourcesAttribute = copy(bool = bool.map(f))

  /** Returns a new data with intSlice set to new value */
  def withIntSlice(value: io.k8s.api.resource.v1alpha2.NamedResourcesIntSlice) : NamedResourcesAttribute = copy(intSlice = Some(value))
  /** if intSlice has a value, transforms to the result of function*/
  def mapIntSlice(f: io.k8s.api.resource.v1alpha2.NamedResourcesIntSlice => io.k8s.api.resource.v1alpha2.NamedResourcesIntSlice) : NamedResourcesAttribute = copy(intSlice = intSlice.map(f))

  /** Returns a new data with int set to new value */
  def withInt(value: Long) : NamedResourcesAttribute = copy(int = Some(value))
  /** if int has a value, transforms to the result of function*/
  def mapInt(f: Long => Long) : NamedResourcesAttribute = copy(int = int.map(f))
}

object NamedResourcesAttribute {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.NamedResourcesAttribute] = new Encoder[io.k8s.api.resource.v1alpha2.NamedResourcesAttribute] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.NamedResourcesAttribute) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("quantity", o.quantity)
            .write("stringSlice", o.stringSlice)
            .write("string", o.string)
            .write("version", o.version)
            .write("bool", o.bool)
            .write("intSlice", o.intSlice)
            .write("int", o.int)
            .build
        }
    }

    implicit val decoder: Decoder[NamedResourcesAttribute] = new Decoder[NamedResourcesAttribute] {
      def apply[T : Reader](t: T): Either[String, NamedResourcesAttribute] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          quantity <- obj.readOpt[io.k8s.apimachinery.pkg.api.resource.Quantity]("quantity")
          stringSlice <- obj.readOpt[io.k8s.api.resource.v1alpha2.NamedResourcesStringSlice]("stringSlice")
          string <- obj.readOpt[String]("string")
          version <- obj.readOpt[String]("version")
          bool <- obj.readOpt[Boolean]("bool")
          intSlice <- obj.readOpt[io.k8s.api.resource.v1alpha2.NamedResourcesIntSlice]("intSlice")
          int <- obj.readOpt[Long]("int")
      } yield NamedResourcesAttribute (
          name = name,
          quantity = quantity,
          stringSlice = stringSlice,
          string = string,
          version = version,
          bool = bool,
          intSlice = intSlice,
          int = int
        )
    }
}

