package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** AppArmorProfile defines a pod or container's AppArmor settings. */
final case class AppArmorProfile(
  `type` : String,
  localhostProfile : Option[String] = None
) {

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : AppArmorProfile = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : AppArmorProfile = copy(`type` = f(`type`))

  /** Returns a new data with localhostProfile set to new value */
  def withLocalhostProfile(value: String) : AppArmorProfile = copy(localhostProfile = Some(value))
  /** if localhostProfile has a value, transforms to the result of function*/
  def mapLocalhostProfile(f: String => String) : AppArmorProfile = copy(localhostProfile = localhostProfile.map(f))
}

object AppArmorProfile {

    implicit val encoder : Encoder[io.k8s.api.core.v1.AppArmorProfile] = new Encoder[io.k8s.api.core.v1.AppArmorProfile] {
        def apply[T : Builder](o: io.k8s.api.core.v1.AppArmorProfile) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("type", o.`type`)
            .write("localhostProfile", o.localhostProfile)
            .build
        }
    }

    implicit val decoder: Decoder[AppArmorProfile] = new Decoder[AppArmorProfile] {
      def apply[T : Reader](t: T): Either[String, AppArmorProfile] = for {
          obj <- ObjectReader(t)
          `type` <- obj.read[String]("type")
          localhostProfile <- obj.readOpt[String]("localhostProfile")
      } yield AppArmorProfile (
          `type` = `type`,
          localhostProfile = localhostProfile
        )
    }
}

