package io.k8s.api.flowcontrol.v1

import dev.hnaderi.k8s.utils._

/** ServiceAccountSubject holds detailed information for service-account-kind subject. */
final case class ServiceAccountSubject(
  name : String,
  namespace : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ServiceAccountSubject = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ServiceAccountSubject = copy(name = f(name))

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : ServiceAccountSubject = copy(namespace = value)
  /** transforms namespace to result of function */
  def mapNamespace(f: String => String) : ServiceAccountSubject = copy(namespace = f(namespace))
}

object ServiceAccountSubject {

    implicit val encoder : Encoder[io.k8s.api.flowcontrol.v1.ServiceAccountSubject] = new Encoder[io.k8s.api.flowcontrol.v1.ServiceAccountSubject] {
        def apply[T : Builder](o: io.k8s.api.flowcontrol.v1.ServiceAccountSubject) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("namespace", o.namespace)
            .build
        }
    }

    implicit val decoder: Decoder[ServiceAccountSubject] = new Decoder[ServiceAccountSubject] {
      def apply[T : Reader](t: T): Either[String, ServiceAccountSubject] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          namespace <- obj.read[String]("namespace")
      } yield ServiceAccountSubject (
          name = name,
          namespace = namespace
        )
    }
}

