package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Represents an empty directory for a pod. Empty directory volumes support ownership management and SELinux relabeling. */
final case class EmptyDirVolumeSource(
  medium : Option[String] = None,
  sizeLimit : Option[io.k8s.apimachinery.pkg.api.resource.Quantity] = None
) {

  /** Returns a new data with medium set to new value */
  def withMedium(value: String) : EmptyDirVolumeSource = copy(medium = Some(value))
  /** if medium has a value, transforms to the result of function*/
  def mapMedium(f: String => String) : EmptyDirVolumeSource = copy(medium = medium.map(f))

  /** Returns a new data with sizeLimit set to new value */
  def withSizeLimit(value: io.k8s.apimachinery.pkg.api.resource.Quantity) : EmptyDirVolumeSource = copy(sizeLimit = Some(value))
  /** if sizeLimit has a value, transforms to the result of function*/
  def mapSizeLimit(f: io.k8s.apimachinery.pkg.api.resource.Quantity => io.k8s.apimachinery.pkg.api.resource.Quantity) : EmptyDirVolumeSource = copy(sizeLimit = sizeLimit.map(f))
}

object EmptyDirVolumeSource {

    implicit val encoder : Encoder[io.k8s.api.core.v1.EmptyDirVolumeSource] = new Encoder[io.k8s.api.core.v1.EmptyDirVolumeSource] {
        def apply[T : Builder](o: io.k8s.api.core.v1.EmptyDirVolumeSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("medium", o.medium)
            .write("sizeLimit", o.sizeLimit)
            .build
        }
    }

    implicit val decoder: Decoder[EmptyDirVolumeSource] = new Decoder[EmptyDirVolumeSource] {
      def apply[T : Reader](t: T): Either[String, EmptyDirVolumeSource] = for {
          obj <- ObjectReader(t)
          medium <- obj.readOpt[String]("medium")
          sizeLimit <- obj.readOpt[io.k8s.apimachinery.pkg.api.resource.Quantity]("sizeLimit")
      } yield EmptyDirVolumeSource (
          medium = medium,
          sizeLimit = sizeLimit
        )
    }
}

