package io.k8s.api.networking.v1alpha1

import dev.hnaderi.k8s.utils._

/** ParentReference describes a reference to a parent object. */
final case class ParentReference(
  name : Option[String] = None,
  resource : Option[String] = None,
  uid : Option[String] = None,
  group : Option[String] = None,
  namespace : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ParentReference = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : ParentReference = copy(name = name.map(f))

  /** Returns a new data with resource set to new value */
  def withResource(value: String) : ParentReference = copy(resource = Some(value))
  /** if resource has a value, transforms to the result of function*/
  def mapResource(f: String => String) : ParentReference = copy(resource = resource.map(f))

  /** Returns a new data with uid set to new value */
  def withUid(value: String) : ParentReference = copy(uid = Some(value))
  /** if uid has a value, transforms to the result of function*/
  def mapUid(f: String => String) : ParentReference = copy(uid = uid.map(f))

  /** Returns a new data with group set to new value */
  def withGroup(value: String) : ParentReference = copy(group = Some(value))
  /** if group has a value, transforms to the result of function*/
  def mapGroup(f: String => String) : ParentReference = copy(group = group.map(f))

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : ParentReference = copy(namespace = Some(value))
  /** if namespace has a value, transforms to the result of function*/
  def mapNamespace(f: String => String) : ParentReference = copy(namespace = namespace.map(f))
}

object ParentReference {

    implicit val encoder : Encoder[io.k8s.api.networking.v1alpha1.ParentReference] = new Encoder[io.k8s.api.networking.v1alpha1.ParentReference] {
        def apply[T : Builder](o: io.k8s.api.networking.v1alpha1.ParentReference) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("resource", o.resource)
            .write("uid", o.uid)
            .write("group", o.group)
            .write("namespace", o.namespace)
            .build
        }
    }

    implicit val decoder: Decoder[ParentReference] = new Decoder[ParentReference] {
      def apply[T : Reader](t: T): Either[String, ParentReference] = for {
          obj <- ObjectReader(t)
          name <- obj.readOpt[String]("name")
          resource <- obj.readOpt[String]("resource")
          uid <- obj.readOpt[String]("uid")
          group <- obj.readOpt[String]("group")
          namespace <- obj.readOpt[String]("namespace")
      } yield ParentReference (
          name = name,
          resource = resource,
          uid = uid,
          group = group,
          namespace = namespace
        )
    }
}

