package io.k8s.api.flowcontrol.v1beta3

import dev.hnaderi.k8s.utils._

/** PriorityLevelConfigurationReference contains information that points to the "request-priority" being used. */
final case class PriorityLevelConfigurationReference(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : PriorityLevelConfigurationReference = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : PriorityLevelConfigurationReference = copy(name = f(name))
}

object PriorityLevelConfigurationReference {

    implicit val encoder : Encoder[io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationReference] = new Encoder[io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationReference] {
        def apply[T : Builder](o: io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationReference) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .build
        }
    }

    implicit val decoder: Decoder[PriorityLevelConfigurationReference] = new Decoder[PriorityLevelConfigurationReference] {
      def apply[T : Reader](t: T): Either[String, PriorityLevelConfigurationReference] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
      } yield PriorityLevelConfigurationReference (
          name = name
        )
    }
}

