package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ResourceClaimList is a collection of claims. */
final case class ResourceClaimList(
  items : Seq[io.k8s.api.resource.v1alpha2.ResourceClaim],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("resource.k8s.io", "ResourceClaimList", "v1alpha2")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.resource.v1alpha2.ResourceClaim]) : ResourceClaimList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.resource.v1alpha2.ResourceClaim*) : ResourceClaimList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.resource.v1alpha2.ResourceClaim] => Seq[io.k8s.api.resource.v1alpha2.ResourceClaim]) : ResourceClaimList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ResourceClaimList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ResourceClaimList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ResourceClaimList.encoder.apply(this)
}

object ResourceClaimList {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.ResourceClaimList] = new Encoder[io.k8s.api.resource.v1alpha2.ResourceClaimList] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.ResourceClaimList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClaimList] = new Decoder[ResourceClaimList] {
      def apply[T : Reader](t: T): Either[String, ResourceClaimList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.resource.v1alpha2.ResourceClaim]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield ResourceClaimList (
          items = items,
          metadata = metadata
        )
    }
}

