package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** ClaimSource describes a reference to a ResourceClaim.

Exactly one of these fields should be set.  Consumers of this type must treat an empty object as if it has an unknown value. */
final case class ClaimSource(
  resourceClaimName : Option[String] = None,
  resourceClaimTemplateName : Option[String] = None
) {

  /** Returns a new data with resourceClaimName set to new value */
  def withResourceClaimName(value: String) : ClaimSource = copy(resourceClaimName = Some(value))
  /** if resourceClaimName has a value, transforms to the result of function*/
  def mapResourceClaimName(f: String => String) : ClaimSource = copy(resourceClaimName = resourceClaimName.map(f))

  /** Returns a new data with resourceClaimTemplateName set to new value */
  def withResourceClaimTemplateName(value: String) : ClaimSource = copy(resourceClaimTemplateName = Some(value))
  /** if resourceClaimTemplateName has a value, transforms to the result of function*/
  def mapResourceClaimTemplateName(f: String => String) : ClaimSource = copy(resourceClaimTemplateName = resourceClaimTemplateName.map(f))
}

object ClaimSource {

    implicit val encoder : Encoder[io.k8s.api.core.v1.ClaimSource] = new Encoder[io.k8s.api.core.v1.ClaimSource] {
        def apply[T : Builder](o: io.k8s.api.core.v1.ClaimSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("resourceClaimName", o.resourceClaimName)
            .write("resourceClaimTemplateName", o.resourceClaimTemplateName)
            .build
        }
    }

    implicit val decoder: Decoder[ClaimSource] = new Decoder[ClaimSource] {
      def apply[T : Reader](t: T): Either[String, ClaimSource] = for {
          obj <- ObjectReader(t)
          resourceClaimName <- obj.readOpt[String]("resourceClaimName")
          resourceClaimTemplateName <- obj.readOpt[String]("resourceClaimTemplateName")
      } yield ClaimSource (
          resourceClaimName = resourceClaimName,
          resourceClaimTemplateName = resourceClaimTemplateName
        )
    }
}

