package io.k8s.api.admissionregistration.v1alpha1

import dev.hnaderi.k8s.utils._

/** ValidatingAdmissionPolicySpec is the specification of the desired behavior of the AdmissionPolicy. */
final case class ValidatingAdmissionPolicySpec(
  matchConditions : Option[Seq[io.k8s.api.admissionregistration.v1alpha1.MatchCondition]] = None,
  validations : Option[Seq[io.k8s.api.admissionregistration.v1alpha1.Validation]] = None,
  paramKind : Option[io.k8s.api.admissionregistration.v1alpha1.ParamKind] = None,
  failurePolicy : Option[String] = None,
  auditAnnotations : Option[Seq[io.k8s.api.admissionregistration.v1alpha1.AuditAnnotation]] = None,
  matchConstraints : Option[io.k8s.api.admissionregistration.v1alpha1.MatchResources] = None
) {

  /** Returns a new data with matchConditions set to new value */
  def withMatchConditions(value: Seq[io.k8s.api.admissionregistration.v1alpha1.MatchCondition]) : ValidatingAdmissionPolicySpec = copy(matchConditions = Some(value))
  /** Appends new values to matchConditions */
  def addMatchConditions(newValues: io.k8s.api.admissionregistration.v1alpha1.MatchCondition*) : ValidatingAdmissionPolicySpec = copy(matchConditions = Some(matchConditions.fold(newValues)(_ ++ newValues)))
  /** if matchConditions has a value, transforms to the result of function*/
  def mapMatchConditions(f: Seq[io.k8s.api.admissionregistration.v1alpha1.MatchCondition] => Seq[io.k8s.api.admissionregistration.v1alpha1.MatchCondition]) : ValidatingAdmissionPolicySpec = copy(matchConditions = matchConditions.map(f))

  /** Returns a new data with validations set to new value */
  def withValidations(value: Seq[io.k8s.api.admissionregistration.v1alpha1.Validation]) : ValidatingAdmissionPolicySpec = copy(validations = Some(value))
  /** Appends new values to validations */
  def addValidations(newValues: io.k8s.api.admissionregistration.v1alpha1.Validation*) : ValidatingAdmissionPolicySpec = copy(validations = Some(validations.fold(newValues)(_ ++ newValues)))
  /** if validations has a value, transforms to the result of function*/
  def mapValidations(f: Seq[io.k8s.api.admissionregistration.v1alpha1.Validation] => Seq[io.k8s.api.admissionregistration.v1alpha1.Validation]) : ValidatingAdmissionPolicySpec = copy(validations = validations.map(f))

  /** Returns a new data with paramKind set to new value */
  def withParamKind(value: io.k8s.api.admissionregistration.v1alpha1.ParamKind) : ValidatingAdmissionPolicySpec = copy(paramKind = Some(value))
  /** if paramKind has a value, transforms to the result of function*/
  def mapParamKind(f: io.k8s.api.admissionregistration.v1alpha1.ParamKind => io.k8s.api.admissionregistration.v1alpha1.ParamKind) : ValidatingAdmissionPolicySpec = copy(paramKind = paramKind.map(f))

  /** Returns a new data with failurePolicy set to new value */
  def withFailurePolicy(value: String) : ValidatingAdmissionPolicySpec = copy(failurePolicy = Some(value))
  /** if failurePolicy has a value, transforms to the result of function*/
  def mapFailurePolicy(f: String => String) : ValidatingAdmissionPolicySpec = copy(failurePolicy = failurePolicy.map(f))

  /** Returns a new data with auditAnnotations set to new value */
  def withAuditAnnotations(value: Seq[io.k8s.api.admissionregistration.v1alpha1.AuditAnnotation]) : ValidatingAdmissionPolicySpec = copy(auditAnnotations = Some(value))
  /** Appends new values to auditAnnotations */
  def addAuditAnnotations(newValues: io.k8s.api.admissionregistration.v1alpha1.AuditAnnotation*) : ValidatingAdmissionPolicySpec = copy(auditAnnotations = Some(auditAnnotations.fold(newValues)(_ ++ newValues)))
  /** if auditAnnotations has a value, transforms to the result of function*/
  def mapAuditAnnotations(f: Seq[io.k8s.api.admissionregistration.v1alpha1.AuditAnnotation] => Seq[io.k8s.api.admissionregistration.v1alpha1.AuditAnnotation]) : ValidatingAdmissionPolicySpec = copy(auditAnnotations = auditAnnotations.map(f))

  /** Returns a new data with matchConstraints set to new value */
  def withMatchConstraints(value: io.k8s.api.admissionregistration.v1alpha1.MatchResources) : ValidatingAdmissionPolicySpec = copy(matchConstraints = Some(value))
  /** if matchConstraints has a value, transforms to the result of function*/
  def mapMatchConstraints(f: io.k8s.api.admissionregistration.v1alpha1.MatchResources => io.k8s.api.admissionregistration.v1alpha1.MatchResources) : ValidatingAdmissionPolicySpec = copy(matchConstraints = matchConstraints.map(f))
}

object ValidatingAdmissionPolicySpec {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec] = new Encoder[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("matchConditions", o.matchConditions)
            .write("validations", o.validations)
            .write("paramKind", o.paramKind)
            .write("failurePolicy", o.failurePolicy)
            .write("auditAnnotations", o.auditAnnotations)
            .write("matchConstraints", o.matchConstraints)
            .build
        }
    }

    implicit val decoder: Decoder[ValidatingAdmissionPolicySpec] = new Decoder[ValidatingAdmissionPolicySpec] {
      def apply[T : Reader](t: T): Either[String, ValidatingAdmissionPolicySpec] = for {
          obj <- ObjectReader(t)
          matchConditions <- obj.readOpt[Seq[io.k8s.api.admissionregistration.v1alpha1.MatchCondition]]("matchConditions")
          validations <- obj.readOpt[Seq[io.k8s.api.admissionregistration.v1alpha1.Validation]]("validations")
          paramKind <- obj.readOpt[io.k8s.api.admissionregistration.v1alpha1.ParamKind]("paramKind")
          failurePolicy <- obj.readOpt[String]("failurePolicy")
          auditAnnotations <- obj.readOpt[Seq[io.k8s.api.admissionregistration.v1alpha1.AuditAnnotation]]("auditAnnotations")
          matchConstraints <- obj.readOpt[io.k8s.api.admissionregistration.v1alpha1.MatchResources]("matchConstraints")
      } yield ValidatingAdmissionPolicySpec (
          matchConditions = matchConditions,
          validations = validations,
          paramKind = paramKind,
          failurePolicy = failurePolicy,
          auditAnnotations = auditAnnotations,
          matchConstraints = matchConstraints
        )
    }
}

