package io.k8s.api.networking.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** IPAddress represents a single IP of a single IP Family. The object is designed to be used by APIs that operate on IP addresses. The object is used by the Service core API for allocation of IP addresses. An IP address can be represented in different formats, to guarantee the uniqueness of the IP, the name of the object is the IP address in canonical format, four decimal digits separated by dots suppressing leading zeros for IPv4 and the representation defined by RFC 5952 for IPv6. Valid: 192.168.1.5 or 2001:db8::1 or 2001:db8:aaaa:bbbb:cccc:dddd:eeee:1 Invalid: 10.01.2.3 or 2001:db8:0:0:0::1 */
final case class IPAddress(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : Option[io.k8s.api.networking.v1alpha1.IPAddressSpec] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "IPAddress", "v1alpha1")


  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : IPAddress = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : IPAddress = copy(metadata = metadata.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.networking.v1alpha1.IPAddressSpec) : IPAddress = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.networking.v1alpha1.IPAddressSpec => io.k8s.api.networking.v1alpha1.IPAddressSpec) : IPAddress = copy(spec = spec.map(f))

  override def foldTo[T : Builder] : T = IPAddress.encoder.apply(this)
}

object IPAddress {

    implicit val encoder : Encoder[io.k8s.api.networking.v1alpha1.IPAddress] = new Encoder[io.k8s.api.networking.v1alpha1.IPAddress] {
        def apply[T : Builder](o: io.k8s.api.networking.v1alpha1.IPAddress) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("metadata", o.metadata)
            .write("spec", o.spec)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[IPAddress] = new Decoder[IPAddress] {
      def apply[T : Reader](t: T): Either[String, IPAddress] = for {
          obj <- ObjectReader(t)
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
          spec <- obj.readOpt[io.k8s.api.networking.v1alpha1.IPAddressSpec]("spec")
      } yield IPAddress (
          metadata = metadata,
          spec = spec
        )
    }
}

