package io.k8s.kube_aggregator.pkg.apis.apiregistration.v1


/** APIServiceStatus contains derived information about an API server */
final case class APIServiceStatus(
  conditions : Option[Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition]] = None
) {

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition]) : APIServiceStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition*) : APIServiceStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition] => Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition]) : APIServiceStatus = copy(conditions = conditions.map(f))
}

