package io.k8s.apimachinery.pkg.apis.meta.v1


/** StatusCause provides more information about an api.Status failure, including cases when multiple errors are encountered. */
final case class StatusCause(
  field : Option[String] = None,
  message : Option[String] = None,
  reason : Option[String] = None
) {

  /** Returns a new data with field set to new value */
  def withField(value: String) : StatusCause = copy(field = Some(value))
  /** if field has a value, transforms to the result of function*/
  def mapField(f: String => String) : StatusCause = copy(field = field.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : StatusCause = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : StatusCause = copy(message = message.map(f))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : StatusCause = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : StatusCause = copy(reason = reason.map(f))
}

