package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** CustomResourceConversion describes how to convert different versions of a CR. */
final case class CustomResourceConversion(
  strategy : String,
  webhook : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookConversion] = None
) {

  /** Returns a new data with strategy set to new value */
  def withStrategy(value: String) : CustomResourceConversion = copy(strategy = value)
  /** transforms strategy to result of function */
  def mapStrategy(f: String => String) : CustomResourceConversion = copy(strategy = f(strategy))

  /** Returns a new data with webhook set to new value */
  def withWebhook(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookConversion) : CustomResourceConversion = copy(webhook = Some(value))
  /** if webhook has a value, transforms to the result of function*/
  def mapWebhook(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookConversion => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookConversion) : CustomResourceConversion = copy(webhook = webhook.map(f))
}

