package io.k8s.api.storage.v1

import dev.hnaderi.k8s._

/** CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster. Kubernetes attach detach controller uses this object to determine whether attach is required. Kubelet uses this object to determine whether pod information needs to be passed on mount. CSIDriver objects are non-namespaced. */
final case class CSIDriver(
  spec : io.k8s.api.storage.v1.CSIDriverSpec,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("storage.k8s.io", "CSIDriver", "v1")


  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.storage.v1.CSIDriverSpec) : CSIDriver = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.storage.v1.CSIDriverSpec => io.k8s.api.storage.v1.CSIDriverSpec) : CSIDriver = copy(spec = f(spec))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : CSIDriver = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : CSIDriver = copy(metadata = metadata.map(f))
}

