package io.k8s.api.policy.v1


/** PodDisruptionBudgetStatus represents information about the status of a PodDisruptionBudget. Status may trail the actual state of a system. */
final case class PodDisruptionBudgetStatus(
  disruptionsAllowed : Int,
  desiredHealthy : Int,
  expectedPods : Int,
  currentHealthy : Int,
  conditions : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]] = None,
  disruptedPods : Option[Map[String, io.k8s.apimachinery.pkg.apis.meta.v1.Time]] = None,
  observedGeneration : Option[Int] = None
) {

  /** Returns a new data with disruptionsAllowed set to new value */
  def withDisruptionsAllowed(value: Int) : PodDisruptionBudgetStatus = copy(disruptionsAllowed = value)
  /** transforms disruptionsAllowed to result of function */
  def mapDisruptionsAllowed(f: Int => Int) : PodDisruptionBudgetStatus = copy(disruptionsAllowed = f(disruptionsAllowed))

  /** Returns a new data with desiredHealthy set to new value */
  def withDesiredHealthy(value: Int) : PodDisruptionBudgetStatus = copy(desiredHealthy = value)
  /** transforms desiredHealthy to result of function */
  def mapDesiredHealthy(f: Int => Int) : PodDisruptionBudgetStatus = copy(desiredHealthy = f(desiredHealthy))

  /** Returns a new data with expectedPods set to new value */
  def withExpectedPods(value: Int) : PodDisruptionBudgetStatus = copy(expectedPods = value)
  /** transforms expectedPods to result of function */
  def mapExpectedPods(f: Int => Int) : PodDisruptionBudgetStatus = copy(expectedPods = f(expectedPods))

  /** Returns a new data with currentHealthy set to new value */
  def withCurrentHealthy(value: Int) : PodDisruptionBudgetStatus = copy(currentHealthy = value)
  /** transforms currentHealthy to result of function */
  def mapCurrentHealthy(f: Int => Int) : PodDisruptionBudgetStatus = copy(currentHealthy = f(currentHealthy))

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]) : PodDisruptionBudgetStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.Condition*) : PodDisruptionBudgetStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition] => Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]) : PodDisruptionBudgetStatus = copy(conditions = conditions.map(f))

  /** Returns a new data with disruptedPods set to new value */
  def withDisruptedPods(value: Map[String, io.k8s.apimachinery.pkg.apis.meta.v1.Time]) : PodDisruptionBudgetStatus = copy(disruptedPods = Some(value))
  /** Adds new values to disruptedPods */
  def addDisruptedPods(newValues: (String, io.k8s.apimachinery.pkg.apis.meta.v1.Time)*) : PodDisruptionBudgetStatus = copy(disruptedPods = Some(disruptedPods.fold(newValues.toMap)(_ ++ newValues)))
  /** if disruptedPods has a value, transforms to the result of function*/
  def mapDisruptedPods(f: Map[String, io.k8s.apimachinery.pkg.apis.meta.v1.Time] => Map[String, io.k8s.apimachinery.pkg.apis.meta.v1.Time]) : PodDisruptionBudgetStatus = copy(disruptedPods = disruptedPods.map(f))

  /** Returns a new data with observedGeneration set to new value */
  def withObservedGeneration(value: Int) : PodDisruptionBudgetStatus = copy(observedGeneration = Some(value))
  /** if observedGeneration has a value, transforms to the result of function*/
  def mapObservedGeneration(f: Int => Int) : PodDisruptionBudgetStatus = copy(observedGeneration = observedGeneration.map(f))
}

