package io.k8s.api.flowcontrol.v1beta1

import dev.hnaderi.k8s._

/** FlowSchemaList is a list of FlowSchema objects. */
final case class FlowSchemaList(
  items : Seq[io.k8s.api.flowcontrol.v1beta1.FlowSchema],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("flowcontrol.apiserver.k8s.io", "FlowSchemaList", "v1beta1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.flowcontrol.v1beta1.FlowSchema]) : FlowSchemaList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.flowcontrol.v1beta1.FlowSchema*) : FlowSchemaList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.flowcontrol.v1beta1.FlowSchema] => Seq[io.k8s.api.flowcontrol.v1beta1.FlowSchema]) : FlowSchemaList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : FlowSchemaList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : FlowSchemaList = copy(metadata = metadata.map(f))
}

