package io.k8s.api.core.v1


/** VolumeNodeAffinity defines constraints that limit what nodes this volume can be accessed from. */
final case class VolumeNodeAffinity(
  required : Option[io.k8s.api.core.v1.NodeSelector] = None
) {

  /** Returns a new data with required set to new value */
  def withRequired(value: io.k8s.api.core.v1.NodeSelector) : VolumeNodeAffinity = copy(required = Some(value))
  /** if required has a value, transforms to the result of function*/
  def mapRequired(f: io.k8s.api.core.v1.NodeSelector => io.k8s.api.core.v1.NodeSelector) : VolumeNodeAffinity = copy(required = required.map(f))
}

