package io.k8s.api.core.v1


/** NodeConfigStatus describes the status of the config assigned by Node.Spec.ConfigSource. */
final case class NodeConfigStatus(
  active : Option[io.k8s.api.core.v1.NodeConfigSource] = None,
  assigned : Option[io.k8s.api.core.v1.NodeConfigSource] = None,
  error : Option[String] = None,
  lastKnownGood : Option[io.k8s.api.core.v1.NodeConfigSource] = None
) {

  /** Returns a new data with active set to new value */
  def withActive(value: io.k8s.api.core.v1.NodeConfigSource) : NodeConfigStatus = copy(active = Some(value))
  /** if active has a value, transforms to the result of function*/
  def mapActive(f: io.k8s.api.core.v1.NodeConfigSource => io.k8s.api.core.v1.NodeConfigSource) : NodeConfigStatus = copy(active = active.map(f))

  /** Returns a new data with assigned set to new value */
  def withAssigned(value: io.k8s.api.core.v1.NodeConfigSource) : NodeConfigStatus = copy(assigned = Some(value))
  /** if assigned has a value, transforms to the result of function*/
  def mapAssigned(f: io.k8s.api.core.v1.NodeConfigSource => io.k8s.api.core.v1.NodeConfigSource) : NodeConfigStatus = copy(assigned = assigned.map(f))

  /** Returns a new data with error set to new value */
  def withError(value: String) : NodeConfigStatus = copy(error = Some(value))
  /** if error has a value, transforms to the result of function*/
  def mapError(f: String => String) : NodeConfigStatus = copy(error = error.map(f))

  /** Returns a new data with lastKnownGood set to new value */
  def withLastKnownGood(value: io.k8s.api.core.v1.NodeConfigSource) : NodeConfigStatus = copy(lastKnownGood = Some(value))
  /** if lastKnownGood has a value, transforms to the result of function*/
  def mapLastKnownGood(f: io.k8s.api.core.v1.NodeConfigSource => io.k8s.api.core.v1.NodeConfigSource) : NodeConfigStatus = copy(lastKnownGood = lastKnownGood.map(f))
}

