package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** Namespace provides a scope for Names. Use of multiple namespaces is optional. */
final case class Namespace(
  status : Option[io.k8s.api.core.v1.NamespaceStatus] = None,
  spec : Option[io.k8s.api.core.v1.NamespaceSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "Namespace", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.core.v1.NamespaceStatus) : Namespace = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.core.v1.NamespaceStatus => io.k8s.api.core.v1.NamespaceStatus) : Namespace = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.core.v1.NamespaceSpec) : Namespace = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.core.v1.NamespaceSpec => io.k8s.api.core.v1.NamespaceSpec) : Namespace = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Namespace = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Namespace = copy(metadata = metadata.map(f))
}

