package io.k8s.api.autoscaling.v1


/** CrossVersionObjectReference contains enough information to let you identify the referred resource. */
final case class CrossVersionObjectReference(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : CrossVersionObjectReference = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : CrossVersionObjectReference = copy(name = f(name))
}

