package io.k8s.api.authorization.v1

import dev.hnaderi.k8s._

/** SelfSubjectAccessReview checks whether or the current user can perform an action.  Not filling in a spec.namespace means "in all namespaces".  Self is a special case, because users should always be able to check whether they can perform an action */
final case class SelfSubjectAccessReview(
  spec : io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec,
  status : Option[io.k8s.api.authorization.v1.SubjectAccessReviewStatus] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("authorization.k8s.io", "SelfSubjectAccessReview", "v1")


  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec) : SelfSubjectAccessReview = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec => io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec) : SelfSubjectAccessReview = copy(spec = f(spec))

  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.authorization.v1.SubjectAccessReviewStatus) : SelfSubjectAccessReview = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.authorization.v1.SubjectAccessReviewStatus => io.k8s.api.authorization.v1.SubjectAccessReviewStatus) : SelfSubjectAccessReview = copy(status = status.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : SelfSubjectAccessReview = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : SelfSubjectAccessReview = copy(metadata = metadata.map(f))
}

