package io.k8s.api.apps.v1


/** StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy. */
final case class StatefulSetUpdateStrategy(
  rollingUpdate : Option[io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy] = None,
  `type` : Option[String] = None
) {

  /** Returns a new data with rollingUpdate set to new value */
  def withRollingUpdate(value: io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy) : StatefulSetUpdateStrategy = copy(rollingUpdate = Some(value))
  /** if rollingUpdate has a value, transforms to the result of function*/
  def mapRollingUpdate(f: io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy => io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy) : StatefulSetUpdateStrategy = copy(rollingUpdate = rollingUpdate.map(f))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : StatefulSetUpdateStrategy = copy(`type` = Some(value))
  /** if `type` has a value, transforms to the result of function*/
  def mapType(f: String => String) : StatefulSetUpdateStrategy = copy(`type` = `type`.map(f))
}

