package io.k8s.api.apps.v1


/** A StatefulSetSpec is the specification of a StatefulSet. */
final case class StatefulSetSpec(
  serviceName : String,
  template : io.k8s.api.core.v1.PodTemplateSpec,
  selector : io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector,
  minReadySeconds : Option[Int] = None,
  replicas : Option[Int] = None,
  revisionHistoryLimit : Option[Int] = None,
  podManagementPolicy : Option[String] = None,
  volumeClaimTemplates : Option[Seq[io.k8s.api.core.v1.PersistentVolumeClaim]] = None,
  persistentVolumeClaimRetentionPolicy : Option[io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicy] = None,
  updateStrategy : Option[io.k8s.api.apps.v1.StatefulSetUpdateStrategy] = None
) {

  /** Returns a new data with serviceName set to new value */
  def withServiceName(value: String) : StatefulSetSpec = copy(serviceName = value)
  /** transforms serviceName to result of function */
  def mapServiceName(f: String => String) : StatefulSetSpec = copy(serviceName = f(serviceName))

  /** Returns a new data with template set to new value */
  def withTemplate(value: io.k8s.api.core.v1.PodTemplateSpec) : StatefulSetSpec = copy(template = value)
  /** transforms template to result of function */
  def mapTemplate(f: io.k8s.api.core.v1.PodTemplateSpec => io.k8s.api.core.v1.PodTemplateSpec) : StatefulSetSpec = copy(template = f(template))

  /** Returns a new data with selector set to new value */
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : StatefulSetSpec = copy(selector = value)
  /** transforms selector to result of function */
  def mapSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : StatefulSetSpec = copy(selector = f(selector))

  /** Returns a new data with minReadySeconds set to new value */
  def withMinReadySeconds(value: Int) : StatefulSetSpec = copy(minReadySeconds = Some(value))
  /** if minReadySeconds has a value, transforms to the result of function*/
  def mapMinReadySeconds(f: Int => Int) : StatefulSetSpec = copy(minReadySeconds = minReadySeconds.map(f))

  /** Returns a new data with replicas set to new value */
  def withReplicas(value: Int) : StatefulSetSpec = copy(replicas = Some(value))
  /** if replicas has a value, transforms to the result of function*/
  def mapReplicas(f: Int => Int) : StatefulSetSpec = copy(replicas = replicas.map(f))

  /** Returns a new data with revisionHistoryLimit set to new value */
  def withRevisionHistoryLimit(value: Int) : StatefulSetSpec = copy(revisionHistoryLimit = Some(value))
  /** if revisionHistoryLimit has a value, transforms to the result of function*/
  def mapRevisionHistoryLimit(f: Int => Int) : StatefulSetSpec = copy(revisionHistoryLimit = revisionHistoryLimit.map(f))

  /** Returns a new data with podManagementPolicy set to new value */
  def withPodManagementPolicy(value: String) : StatefulSetSpec = copy(podManagementPolicy = Some(value))
  /** if podManagementPolicy has a value, transforms to the result of function*/
  def mapPodManagementPolicy(f: String => String) : StatefulSetSpec = copy(podManagementPolicy = podManagementPolicy.map(f))

  /** Returns a new data with volumeClaimTemplates set to new value */
  def withVolumeClaimTemplates(value: Seq[io.k8s.api.core.v1.PersistentVolumeClaim]) : StatefulSetSpec = copy(volumeClaimTemplates = Some(value))
  /** Appends new values to volumeClaimTemplates */
  def addVolumeClaimTemplates(newValues: io.k8s.api.core.v1.PersistentVolumeClaim*) : StatefulSetSpec = copy(volumeClaimTemplates = Some(volumeClaimTemplates.fold(newValues)(_ ++ newValues)))
  /** if volumeClaimTemplates has a value, transforms to the result of function*/
  def mapVolumeClaimTemplates(f: Seq[io.k8s.api.core.v1.PersistentVolumeClaim] => Seq[io.k8s.api.core.v1.PersistentVolumeClaim]) : StatefulSetSpec = copy(volumeClaimTemplates = volumeClaimTemplates.map(f))

  /** Returns a new data with persistentVolumeClaimRetentionPolicy set to new value */
  def withPersistentVolumeClaimRetentionPolicy(value: io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicy) : StatefulSetSpec = copy(persistentVolumeClaimRetentionPolicy = Some(value))
  /** if persistentVolumeClaimRetentionPolicy has a value, transforms to the result of function*/
  def mapPersistentVolumeClaimRetentionPolicy(f: io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicy => io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicy) : StatefulSetSpec = copy(persistentVolumeClaimRetentionPolicy = persistentVolumeClaimRetentionPolicy.map(f))

  /** Returns a new data with updateStrategy set to new value */
  def withUpdateStrategy(value: io.k8s.api.apps.v1.StatefulSetUpdateStrategy) : StatefulSetSpec = copy(updateStrategy = Some(value))
  /** if updateStrategy has a value, transforms to the result of function*/
  def mapUpdateStrategy(f: io.k8s.api.apps.v1.StatefulSetUpdateStrategy => io.k8s.api.apps.v1.StatefulSetUpdateStrategy) : StatefulSetSpec = copy(updateStrategy = updateStrategy.map(f))
}

