/*
 * Copyright 2022 Hossein Naderi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package dev.hnaderi.k8s

import dev.hnaderi.k8s.circe.codecs._
import io.circe.Json
import io.circe.syntax._
import io.circe.yaml.syntax._

package object manifest {
  implicit class KObjectsOps(val objs: Iterable[KObject]) extends AnyVal {
    def asManifest: String =
      objs.map(_.asManifest).mkString("\n---\n")
  }
  implicit class KObjectOps(val obj: KObject) extends AnyVal {
    def asManifest: String = obj.asJsonManifest.asYaml.spaces2
    def asJsonManifest: Json = obj.asJson.deepDropNullValues
  }
}
