/*
 * Decompiled with CFR 0.152.
 */
package dev.hnaderi.k8s.client;

import dev.hnaderi.k8s.client.AuthInfo;
import dev.hnaderi.k8s.client.Cluster;
import dev.hnaderi.k8s.client.Conversions$;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class SSLContexts$
implements Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(SSLContexts$.class.getDeclaredField("defaultKeyStore$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(SSLContexts$.class.getDeclaredField("defaultTrustStore$lzy1"));
    private static final String TrustStoreSystemProperty;
    private static String TrustStorePasswordSystemProperty;
    private static final String KeyStoreSystemProperty;
    private static String KeyStorePasswordSystemProperty;
    private volatile Object defaultTrustStore$lzy1;
    private volatile Object defaultKeyStore$lzy1;
    public static final SSLContexts$ MODULE$;

    private SSLContexts$() {
    }

    static {
        MODULE$ = new SSLContexts$();
        TrustStoreSystemProperty = "javax.net.ssl.trustStore";
        TrustStorePasswordSystemProperty = "javax.net.ssl.trustStorePassword";
        KeyStoreSystemProperty = "javax.net.ssl.keyStore";
        KeyStorePasswordSystemProperty = "javax.net.ssl.keyStorePassword";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SSLContexts$.class);
    }

    public SSLContext from(Cluster cluster, AuthInfo auth) {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        Option option = auth.client$minuscertificate().map((Function1 & Serializable)_$1 -> new File((String)_$1));
        Option option2 = auth.client$minuskey().map((Function1 & Serializable)_$2 -> new File((String)_$2));
        None$ none$ = None$.MODULE$;
        sslContext.init(this.keyManagers((Option<File>)option, (Option<String>)auth.client$minuscertificate$minusdata(), (Option<File>)option2, (Option<String>)auth.client$minuskey$minusdata(), (Option<String>)none$), this.trustManagers((Option<String>)cluster.certificate$minusauthority$minusdata(), (Option<File>)cluster.certificate$minusauthority().map((Function1 & Serializable)_$3 -> new File((String)_$3))), new SecureRandom());
        return sslContext;
    }

    public SSLContext fromFile(Option<File> ca, Option<File> clientCert, Option<File> clientKey, Option<String> clientKeyPassword) {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(this.keyManagers(clientCert, this.keyManagers$default$2(), clientKey, this.keyManagers$default$4(), clientKeyPassword), this.trustManagers(this.trustManagers$default$1(), ca), new SecureRandom());
        return sslContext;
    }

    public Option<File> fromFile$default$1() {
        return None$.MODULE$;
    }

    public Option<File> fromFile$default$2() {
        return None$.MODULE$;
    }

    public Option<File> fromFile$default$3() {
        return None$.MODULE$;
    }

    public Option<String> fromFile$default$4() {
        return None$.MODULE$;
    }

    private TrustManager[] trustManagers(Option<String> caData, Option<File> caFile) {
        Option certDataStream = caData.map((Function1 & Serializable)data -> new ByteArrayInputStream(Base64.getDecoder().decode((String)data)));
        Option certFileStream = caFile.map((Function1 & Serializable)_$4 -> new FileInputStream((File)_$4));
        certDataStream.orElse(() -> this.trustManagers$$anonfun$1(certFileStream)).foreach((Function1)(JProcedure1 & Serializable)certStream -> {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            Iterable certificates = Conversions$.MODULE$.CollectionHasAsScala(certificateFactory.generateCertificates((InputStream)certStream)).asScala();
            ((IterableOnceOps)((IterableOps)certificates.map((Function1 & Serializable)_$5 -> (X509Certificate)_$5)).zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    X509Certificate certificate = (X509Certificate)tuple2._1();
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    String alias = certificate.getSubjectX500Principal().getName() + "-" + i;
                    this.defaultTrustStore().setCertificateEntry(alias, certificate);
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
        });
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(this.defaultTrustStore());
        return trustManagerFactory.getTrustManagers();
    }

    private Option<String> trustManagers$default$1() {
        return None$.MODULE$;
    }

    private KeyStore defaultTrustStore() {
        Object object = this.defaultTrustStore$lzy1;
        if (object instanceof KeyStore) {
            return (KeyStore)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (KeyStore)this.defaultTrustStore$lzyINIT1();
    }

    private Object defaultTrustStore$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.defaultTrustStore$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    KeyStore keyStore = null;
                    try {
                        String securityDirectory = System.getProperty("java.home") + "/lib/security";
                        Option propertyTrustStoreFile = Option$.MODULE$.apply((Object)System.getProperty(TrustStoreSystemProperty, "")).filter((Function1 & Serializable)_$6 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$6))).map((Function1 & Serializable)_$7 -> new File((String)_$7));
                        Option jssecacertsFile = Option$.MODULE$.apply((Object)new File(securityDirectory + "/jssecacerts")).filter((Function1 & Serializable)f -> f.exists() && f.isFile());
                        File cacertsFile = new File(securityDirectory + "/cacerts");
                        KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
                        keyStore2.load(new FileInputStream((File)propertyTrustStoreFile.orElse(() -> this.defaultTrustStore$lzyINIT1$$anonfun$1(jssecacertsFile)).getOrElse(() -> this.defaultTrustStore$lzyINIT1$$anonfun$2(cacertsFile))), System.getProperty(TrustStorePasswordSystemProperty, "changeit").toCharArray());
                        keyStore = keyStore2;
                        object2 = keyStore == null ? LazyVals.NullValue$.MODULE$ : keyStore;
                        TrustStorePasswordSystemProperty = null;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultTrustStore$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultTrustStore$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return keyStore;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private KeyManager[] keyManagers(Option<File> clientCert, Option<String> clientCertData, Option<File> clientKey, Option<String> clientKeyData, Option<String> clientKeyPass) {
        Option certDataStream = clientCertData.map((Function1 & Serializable)data -> new ByteArrayInputStream(Base64.getDecoder().decode((String)data)));
        Option certFileStream = clientCert.map((Function1 & Serializable)_$8 -> new FileInputStream((File)_$8));
        Option keyDataStream = clientKeyData.map((Function1 & Serializable)data -> new ByteArrayInputStream(Base64.getDecoder().decode((String)data)));
        Option keyFileStream = clientKey.map((Function1 & Serializable)_$9 -> new FileInputStream((File)_$9));
        keyDataStream.orElse(() -> this.keyManagers$$anonfun$1(keyFileStream)).flatMap((Function1 & Serializable)keyStream -> certDataStream.orElse(() -> this.keyManagers$$anonfun$2$$anonfun$1(certFileStream)).map((Function1)(JProcedure1 & Serializable)certStream -> {
            Security.addProvider((Provider)new BouncyCastleProvider());
            PEMKeyPair pemKeyPair = (PEMKeyPair)new PEMParser((Reader)new InputStreamReader((InputStream)keyStream)).readObject();
            PrivateKey privateKey = new JcaPEMKeyConverter().setProvider("BC").getPrivateKey(pemKeyPair.getPrivateKeyInfo());
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)certStream);
            this.defaultKeyStore().setKeyEntry(certificate.getSubjectX500Principal().getName(), privateKey, (char[])clientKeyPass.fold(this::keyManagers$$anonfun$2$$anonfun$2$$anonfun$1, (Function1 & Serializable)_$10 -> _$10.toCharArray()), new Certificate[]{certificate});
        }));
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(this.defaultKeyStore(), (char[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Character.TYPE)));
        return keyManagerFactory.getKeyManagers();
    }

    private Option<String> keyManagers$default$2() {
        return None$.MODULE$;
    }

    private Option<String> keyManagers$default$4() {
        return None$.MODULE$;
    }

    private KeyStore defaultKeyStore() {
        Object object = this.defaultKeyStore$lzy1;
        if (object instanceof KeyStore) {
            return (KeyStore)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (KeyStore)this.defaultKeyStore$lzyINIT1();
    }

    private Object defaultKeyStore$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.defaultKeyStore$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    KeyStore keyStore = null;
                    try {
                        Option propertyKeyStoreFile = Option$.MODULE$.apply((Object)System.getProperty(KeyStoreSystemProperty, "")).filter((Function1 & Serializable)_$11 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$11))).map((Function1 & Serializable)_$12 -> new File((String)_$12));
                        KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
                        keyStore2.load((InputStream)propertyKeyStoreFile.map((Function1 & Serializable)_$13 -> new FileInputStream((File)_$13)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), System.getProperty(KeyStorePasswordSystemProperty, "").toCharArray());
                        keyStore = keyStore2;
                        object2 = keyStore == null ? LazyVals.NullValue$.MODULE$ : keyStore;
                        KeyStorePasswordSystemProperty = null;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultKeyStore$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultKeyStore$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return keyStore;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final Option trustManagers$$anonfun$1(Option certFileStream$1) {
        return certFileStream$1;
    }

    private final Option defaultTrustStore$lzyINIT1$$anonfun$1(Option jssecacertsFile$1) {
        return jssecacertsFile$1;
    }

    private final File defaultTrustStore$lzyINIT1$$anonfun$2(File cacertsFile$1) {
        return cacertsFile$1;
    }

    private final Option keyManagers$$anonfun$1(Option keyFileStream$1) {
        return keyFileStream$1;
    }

    private final Option keyManagers$$anonfun$2$$anonfun$1(Option certFileStream$3) {
        return certFileStream$3;
    }

    private final char[] keyManagers$$anonfun$2$$anonfun$2$$anonfun$1() {
        return (char[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Character.TYPE));
    }
}

