/*
 * Decompiled with CFR 0.152.
 */
package dev.hnaderi.k8s.client;

import dev.hnaderi.k8s.client.AuthInfo;
import dev.hnaderi.k8s.client.Cluster;
import dev.hnaderi.k8s.client.Conversions$;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SSLContexts$ {
    public static final SSLContexts$ MODULE$ = new SSLContexts$();
    private static KeyStore defaultTrustStore;
    private static KeyStore defaultKeyStore;
    private static final String TrustStoreSystemProperty;
    private static String TrustStorePasswordSystemProperty;
    private static final String KeyStoreSystemProperty;
    private static String KeyStorePasswordSystemProperty;
    private static volatile byte bitmap$0;

    static {
        TrustStoreSystemProperty = "javax.net.ssl.trustStore";
        TrustStorePasswordSystemProperty = "javax.net.ssl.trustStorePassword";
        KeyStoreSystemProperty = "javax.net.ssl.keyStore";
        KeyStorePasswordSystemProperty = "javax.net.ssl.keyStorePassword";
    }

    private String TrustStoreSystemProperty() {
        return TrustStoreSystemProperty;
    }

    private String TrustStorePasswordSystemProperty() {
        return TrustStorePasswordSystemProperty;
    }

    private String KeyStoreSystemProperty() {
        return KeyStoreSystemProperty;
    }

    private String KeyStorePasswordSystemProperty() {
        return KeyStorePasswordSystemProperty;
    }

    public SSLContext from(Cluster cluster, AuthInfo auth) {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        Option x$12 = auth.client$minuscertificate$minusdata();
        Option x$22 = auth.client$minuscertificate().map((Function1 & Serializable)x$1 -> new File((String)x$1));
        Option x$32 = auth.client$minuskey$minusdata();
        Option x$4 = auth.client$minuskey().map((Function1 & Serializable)x$2 -> new File((String)x$2));
        None$ x$5 = None$.MODULE$;
        sslContext.init(this.keyManagers((Option<File>)x$22, (Option<String>)x$12, (Option<File>)x$4, (Option<String>)x$32, (Option<String>)x$5), this.trustManagers((Option<String>)cluster.certificate$minusauthority$minusdata(), (Option<File>)cluster.certificate$minusauthority().map((Function1 & Serializable)x$3 -> new File((String)x$3))), new SecureRandom());
        return sslContext;
    }

    public SSLContext fromFile(Option<File> ca, Option<File> clientCert, Option<File> clientKey, Option<String> clientKeyPassword) {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        Option<File> x$1 = clientCert;
        Option<File> x$2 = clientKey;
        Option<String> x$3 = clientKeyPassword;
        Option<String> x$4 = this.keyManagers$default$2();
        Option<String> x$5 = this.keyManagers$default$4();
        Option<File> x$6 = ca;
        Option<String> x$7 = this.trustManagers$default$1();
        sslContext.init(this.keyManagers(x$1, x$4, x$2, x$5, x$3), this.trustManagers(x$7, x$6), new SecureRandom());
        return sslContext;
    }

    public Option<File> fromFile$default$1() {
        return None$.MODULE$;
    }

    public Option<File> fromFile$default$2() {
        return None$.MODULE$;
    }

    public Option<File> fromFile$default$3() {
        return None$.MODULE$;
    }

    public Option<String> fromFile$default$4() {
        return None$.MODULE$;
    }

    private TrustManager[] trustManagers(Option<String> caData, Option<File> caFile) {
        Option certDataStream = caData.map((Function1 & Serializable)data -> new ByteArrayInputStream(Base64.getDecoder().decode((String)data)));
        Option certFileStream = caFile.map((Function1 & Serializable)x$4 -> new FileInputStream((File)x$4));
        certDataStream.orElse((Function0 & Serializable)() -> certFileStream).foreach((Function1 & Serializable)certStream -> {
            SSLContexts$.$anonfun$trustManagers$4(certStream);
            return BoxedUnit.UNIT;
        });
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(this.defaultTrustStore());
        return trustManagerFactory.getTrustManagers();
    }

    private Option<String> trustManagers$default$1() {
        return None$.MODULE$;
    }

    private KeyStore defaultTrustStore$lzycompute() {
        SSLContexts$ sSLContexts$ = this;
        synchronized (sSLContexts$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                String securityDirectory = System.getProperty("java.home") + "/lib/security";
                Option propertyTrustStoreFile = Option$.MODULE$.apply((Object)System.getProperty(this.TrustStoreSystemProperty(), "")).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$6)))).map((Function1 & Serializable)x$7 -> new File((String)x$7));
                Option jssecacertsFile = Option$.MODULE$.apply((Object)new File(securityDirectory + "/jssecacerts")).filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SSLContexts$.$anonfun$defaultTrustStore$3(f)));
                File cacertsFile = new File(securityDirectory + "/cacerts");
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(new FileInputStream((File)propertyTrustStoreFile.orElse((Function0 & Serializable)() -> jssecacertsFile).getOrElse((Function0 & Serializable)() -> cacertsFile)), System.getProperty(this.TrustStorePasswordSystemProperty(), "changeit").toCharArray());
                defaultTrustStore = keyStore;
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        TrustStorePasswordSystemProperty = null;
        return defaultTrustStore;
    }

    private KeyStore defaultTrustStore() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.defaultTrustStore$lzycompute();
        }
        return defaultTrustStore;
    }

    private KeyManager[] keyManagers(Option<File> clientCert, Option<String> clientCertData, Option<File> clientKey, Option<String> clientKeyData, Option<String> clientKeyPass) {
        Option certDataStream = clientCertData.map((Function1 & Serializable)data -> new ByteArrayInputStream(Base64.getDecoder().decode((String)data)));
        Option certFileStream = clientCert.map((Function1 & Serializable)x$8 -> new FileInputStream((File)x$8));
        Option keyDataStream = clientKeyData.map((Function1 & Serializable)data -> new ByteArrayInputStream(Base64.getDecoder().decode((String)data)));
        Option keyFileStream = clientKey.map((Function1 & Serializable)x$9 -> new FileInputStream((File)x$9));
        keyDataStream.orElse((Function0 & Serializable)() -> keyFileStream).flatMap((Function1 & Serializable)keyStream -> certDataStream.orElse((Function0 & Serializable)() -> certFileStream).map((Function1 & Serializable)certStream -> {
            SSLContexts$.$anonfun$keyManagers$8(keyStream, clientKeyPass, certStream);
            return BoxedUnit.UNIT;
        }));
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(this.defaultKeyStore(), (char[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Char()));
        return keyManagerFactory.getKeyManagers();
    }

    private Option<String> keyManagers$default$2() {
        return None$.MODULE$;
    }

    private Option<String> keyManagers$default$4() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private KeyStore defaultKeyStore$lzycompute() {
        SSLContexts$ sSLContexts$ = this;
        synchronized (sSLContexts$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                void var3_3;
                Option propertyKeyStoreFile = Option$.MODULE$.apply((Object)System.getProperty(this.KeyStoreSystemProperty(), "")).filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$11)))).map((Function1 & Serializable)x$12 -> new File((String)x$12));
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load((InputStream)propertyKeyStoreFile.map((Function1 & Serializable)x$13 -> new FileInputStream((File)x$13)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), System.getProperty(this.KeyStorePasswordSystemProperty(), "").toCharArray());
                defaultKeyStore = var3_3;
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        KeyStorePasswordSystemProperty = null;
        return defaultKeyStore;
    }

    private KeyStore defaultKeyStore() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.defaultKeyStore$lzycompute();
        }
        return defaultKeyStore;
    }

    public static final /* synthetic */ void $anonfun$trustManagers$6(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            X509Certificate certificate = (X509Certificate)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String alias = certificate.getSubjectX500Principal().getName() + "-" + i;
            MODULE$.defaultTrustStore().setCertificateEntry(alias, certificate);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$trustManagers$4(InputStream certStream) {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
        Iterable certificates = Conversions$.MODULE$.CollectionHasAsScala(certificateFactory.generateCertificates(certStream)).asScala();
        ((IterableOnceOps)((IterableOps)certificates.map((Function1 & Serializable)x$5 -> (X509Certificate)x$5)).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            SSLContexts$.$anonfun$trustManagers$6(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$defaultTrustStore$3(File f) {
        return f.exists() && f.isFile();
    }

    public static final /* synthetic */ void $anonfun$keyManagers$8(InputStream keyStream$1, Option clientKeyPass$1, InputStream certStream) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PEMKeyPair pemKeyPair = (PEMKeyPair)new PEMParser((Reader)new InputStreamReader(keyStream$1)).readObject();
        PrivateKey privateKey = new JcaPEMKeyConverter().setProvider("BC").getPrivateKey(pemKeyPair.getPrivateKeyInfo());
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
        X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(certStream);
        MODULE$.defaultKeyStore().setKeyEntry(certificate.getSubjectX500Principal().getName(), privateKey, (char[])clientKeyPass$1.fold((Function0 & Serializable)() -> (char[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Char()), (Function1 & Serializable)x$10 -> x$10.toCharArray()), (Certificate[])((Object[])new Certificate[]{certificate}));
    }

    private SSLContexts$() {
    }
}

