/*
 * Decompiled with CFR 0.152.
 */
package dev.hnaderi.k8s.client.http4s;

import cats.effect.kernel.GenConcurrent;
import cats.syntax.EitherOps$;
import cats.syntax.ListOps$;
import cats.syntax.package;
import dev.hnaderi.k8s.client.APIVerb;
import dev.hnaderi.k8s.client.ErrorResponse$;
import dev.hnaderi.k8s.client.ErrorStatus;
import dev.hnaderi.k8s.client.HttpBackend;
import dev.hnaderi.k8s.client.PatchType;
import dev.hnaderi.k8s.client.StreamingBackend;
import dev.hnaderi.k8s.client.http4s.Http4sBackend$;
import dev.hnaderi.k8s.utils.Builder;
import dev.hnaderi.k8s.utils.Decoder;
import dev.hnaderi.k8s.utils.Encoder;
import dev.hnaderi.k8s.utils.Reader;
import dev.hnaderi.k8s.utils.package;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import io.k8s.apimachinery.pkg.apis.meta.v1.Status$;
import java.io.Serializable;
import org.http4s.EntityDecoder;
import org.http4s.EntityEncoder;
import org.http4s.Header;
import org.http4s.Headers;
import org.http4s.Headers$;
import org.http4s.InvalidMessageBodyFailure$;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Query;
import org.http4s.Query$;
import org.http4s.Request;
import org.http4s.RequestCookie$;
import org.http4s.Status;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.client.Client;
import org.http4s.client.dsl.Http4sClientDsl;
import org.http4s.client.dsl.MethodOps$;
import org.http4s.headers.Content$minusType$;
import org.http4s.headers.Cookie$;
import org.typelevel.jawn.Facade;
import org.typelevel.jawn.fs2.Absorbable$;
import org.typelevel.jawn.fs2.package$;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;

public final class Http4sBackend<F, T>
implements HttpBackend<F>,
StreamingBackend<?> {
    private final Client<F> client;
    private final GenConcurrent<F, Throwable> F;
    private final EntityEncoder<F, T> enc;
    private final EntityDecoder<F, T> dec;
    private final Builder<T> builder;
    private final Reader<T> reader;
    private final Http4sClientDsl<F> dsl;

    public static <F, T> Http4sBackend<F, T> fromClient(Client<F> client, GenConcurrent<F, Throwable> genConcurrent, EntityEncoder<F, T> entityEncoder, EntityDecoder<F, T> entityDecoder, Builder<T> builder, Reader<T> reader) {
        return Http4sBackend$.MODULE$.fromClient(client, genConcurrent, entityEncoder, entityDecoder, builder, reader);
    }

    public Http4sBackend(Client<F> client, GenConcurrent<F, Throwable> F, EntityEncoder<F, T> enc, EntityDecoder<F, T> dec, Builder<T> builder, Reader<T> reader) {
        this.client = client;
        this.F = F;
        this.enc = enc;
        this.dec = dec;
        this.builder = builder;
        this.reader = reader;
        this.dsl = new Http4sClientDsl<F>(){};
    }

    public <O> F send(String url2, APIVerb verb, scala.collection.immutable.Seq<Tuple2<String, String>> headers, scala.collection.immutable.Seq<Tuple2<String, String>> params, scala.collection.immutable.Seq<Tuple2<String, String>> cookies, Decoder<O> evidence$1) {
        return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.urlFrom(url2, params), this.F).map((Function1 & Serializable)url -> {
            Method method = this.dsl.http4sClientSyntaxMethod(this.methodFor(verb));
            return (Request)MethodOps$.MODULE$.apply$extension(method, url, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.headersToRaw(Headers$.MODULE$.$plus$plus$extension(Headers$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.scalaCollectionSeqToRaw((Seq)headers, (Function1 & Serializable)kv -> Header.ToRaw$.MODULE$.keyValuesToRaw(kv))})), this.cookiesFor(cookies)))})).withContentType(Content$minusType$.MODULE$.apply(this.contentType(verb)));
        }), this.F).flatMap((Function1 & Serializable)_$3 -> this.sendRequest((Request<F>)_$3, evidence$1));
    }

    public <I, O> F send(String url2, APIVerb verb, I body, scala.collection.immutable.Seq<Tuple2<String, String>> headers, scala.collection.immutable.Seq<Tuple2<String, String>> params, scala.collection.immutable.Seq<Tuple2<String, String>> cookies, Encoder<I> evidence$1, Decoder<O> evidence$2) {
        return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.urlFrom(url2, params), this.F).map((Function1 & Serializable)url -> {
            Method method = this.dsl.http4sClientSyntaxMethod(this.methodFor(verb));
            Object object = dev.hnaderi.k8s.utils.package$.MODULE$.EncoderOps(body);
            return (Request)MethodOps$.MODULE$.apply$extension(method, package.EncoderOps$.MODULE$.encodeTo$extension(object, evidence$1, this.builder), url, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.headersToRaw(Headers$.MODULE$.$plus$plus$extension(Headers$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.scalaCollectionSeqToRaw((Seq)headers, (Function1 & Serializable)kv -> Header.ToRaw$.MODULE$.keyValuesToRaw(kv))})), this.cookiesFor(cookies)))}), this.enc).withContentType(Content$minusType$.MODULE$.apply(this.contentType(verb)));
        }), this.F).flatMap((Function1 & Serializable)_$4 -> this.sendRequest((Request<F>)_$4, evidence$2));
    }

    private List cookiesFor(scala.collection.immutable.Seq<Tuple2<String, String>> cookies) {
        List list = package.all$.MODULE$.catsSyntaxList(((IterableOnceOps)cookies.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return RequestCookie$.MODULE$.apply(k, v);
            }
            throw new MatchError((Object)tuple2);
        })).toList());
        Object object = ListOps$.MODULE$.toNel$extension(list).map((Function1 & Serializable)_$5 -> Cookie$.MODULE$.apply(_$5)).fold((Function0 & Serializable)() -> new Headers(Http4sBackend.cookiesFor$$anonfun$3()), (Function1 & Serializable)_$6 -> new Headers(Headers$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)_$6, Cookie$.MODULE$.headerInstance())}))));
        if (object == null) {
            return null;
        }
        return ((Headers)object).headers();
    }

    private <O> F sendRequest(Request<F> req, Decoder<O> evidence$1) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.client.expectOr(req, (Function1 & Serializable)resp -> {
            ErrorStatus.Conflict$ conflict$;
            Status status = resp.status();
            Status status2 = org.http4s.Status$.MODULE$.Conflict();
            Status status3 = status;
            if (!(status2 != null ? !status2.equals(status3) : status3 != null)) {
                conflict$ = ErrorStatus.Conflict$.MODULE$;
            } else {
                Status status4 = org.http4s.Status$.MODULE$.NotFound();
                Status status5 = status;
                if (!(status4 != null ? !status4.equals(status5) : status5 != null)) {
                    conflict$ = ErrorStatus.NotFound$.MODULE$;
                } else {
                    Status status6 = org.http4s.Status$.MODULE$.Unauthorized();
                    Status status7 = status;
                    if (!(status6 != null ? !status6.equals(status7) : status7 != null)) {
                        conflict$ = ErrorStatus.Unauthorized$.MODULE$;
                    } else {
                        Status status8 = org.http4s.Status$.MODULE$.Forbidden();
                        Status status9 = status;
                        if (!(status8 != null ? !status8.equals(status9) : status9 != null)) {
                            conflict$ = ErrorStatus.Forbidden$.MODULE$;
                        } else {
                            Status status10 = org.http4s.Status$.MODULE$.BadRequest();
                            Status status11 = status;
                            if (!(status10 != null ? !status10.equals(status11) : status11 != null)) {
                                conflict$ = ErrorStatus.BadRequest$.MODULE$;
                            } else {
                                Status e = status;
                                conflict$ = ErrorStatus.Other$.MODULE$.apply(e.code());
                            }
                        }
                    }
                }
            }
            ErrorStatus err = (ErrorStatus)conflict$;
            return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(resp.as(this.F, this.dec), this.F).map((Function1 & Serializable)_$7 -> {
                Object object = dev.hnaderi.k8s.utils.package$.MODULE$.DecoderOps(_$7);
                return package.DecoderOps$.MODULE$.decodeTo$extension(object, Status$.MODULE$.decoder(), this.reader);
            }), this.F).flatMap((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Right) {
                    io.k8s.apimachinery.pkg.apis.meta.v1.Status status = (io.k8s.apimachinery.pkg.apis.meta.v1.Status)((Right)either).value();
                    return this.F.raiseError((Object)ErrorResponse$.MODULE$.apply(err, status));
                }
                if (either instanceof Left) {
                    String err = (String)((Left)either).value();
                    return this.F.raiseError((Object)new Exception(err));
                }
                throw new MatchError((Object)either);
            });
        }, this.dec), this.F).flatMap((Function1 & Serializable)t -> {
            Object object = dev.hnaderi.k8s.utils.package$.MODULE$.DecoderOps(t);
            Either either = package.all$.MODULE$.catsSyntaxEither(package.DecoderOps$.MODULE$.decodeTo$extension(object, evidence$1, this.reader));
            return this.F.fromEither(EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)_$8 -> InvalidMessageBodyFailure$.MODULE$.apply(_$8, InvalidMessageBodyFailure$.MODULE$.$lessinit$greater$default$2())));
        });
    }

    public <O> Stream<F, O> connect(String url, APIVerb verb, scala.collection.immutable.Seq<Tuple2<String, String>> headers, scala.collection.immutable.Seq<Tuple2<String, String>> params, scala.collection.immutable.Seq<Tuple2<String, String>> cookies, Decoder<O> evidence$1) {
        Facade.SimpleFacade jawnFacade = dev.hnaderi.k8s.jawn.package$.MODULE$.jawnFacade(this.builder);
        return Stream$.MODULE$.eval(this.urlFrom(url, params)).map((Function1 & Serializable)_$9 -> {
            Method method = this.dsl.http4sClientSyntaxMethod(this.methodFor(verb));
            return MethodOps$.MODULE$.apply$extension(method, _$9, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.headersToRaw(Headers$.MODULE$.$plus$plus$extension(Headers$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.scalaCollectionSeqToRaw((Seq)headers, (Function1 & Serializable)kv -> Header.ToRaw$.MODULE$.keyValuesToRaw(kv))})), this.cookiesFor(cookies)))}));
        }).flatMap((Function1 & Serializable)_$10 -> this.client.stream(_$10), NotGiven$.MODULE$.value()).flatMap((Function1 & Serializable)_$11 -> package$.MODULE$.JsonStreamSyntax(_$11.body().chunks()).parseJsonStream(this.F, Absorbable$.MODULE$.ByteChunkAbsorbable(), (Facade)jawnFacade), NotGiven$.MODULE$.value()).flatMap((Function1 & Serializable)s -> {
            Object object = dev.hnaderi.k8s.utils.package$.MODULE$.DecoderOps(s);
            return (Stream)package.DecoderOps$.MODULE$.decodeTo$extension(object, evidence$1, this.reader).fold((Function1 & Serializable)err -> Stream$.MODULE$.raiseError((Throwable)new Exception(err + "\n" + s), RaiseThrowable$.MODULE$.fromApplicativeError(this.F)), (Function1 & Serializable)_$12 -> Stream$.MODULE$.emit(_$12));
        }, NotGiven$.MODULE$.value());
    }

    private F urlFrom(String str, scala.collection.immutable.Seq<Tuple2<String, String>> params) {
        return (F)package.all$.MODULE$.toFunctorOps(cats.effect.package$.MODULE$.Concurrent().apply(this.F, DummyImplicit$.MODULE$.dummyImplicit()).fromEither(Uri$.MODULE$.fromString(str)), this.F).map((Function1 & Serializable)_$13 -> {
            Query query = Query$.MODULE$.apply((scala.collection.immutable.Seq)params.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    return Tuple2$.MODULE$.apply((Object)k, (Object)Some$.MODULE$.apply((Object)v));
                }
                throw new MatchError((Object)tuple2);
            }));
            Option option = _$13.copy$default$1();
            Option option2 = _$13.copy$default$2();
            Uri.Path path = _$13.copy$default$3();
            Option option3 = _$13.copy$default$5();
            return _$13.copy(option, option2, path, query, option3);
        });
    }

    private Function1<PatchType, MediaType> mediaTypeFor() {
        return (Function1 & Serializable)x$1 -> {
            PatchType patchType = x$1;
            if (PatchType.JsonPatch$.MODULE$.equals(patchType)) {
                return MediaType$.MODULE$.application().json$minuspatch$plusjson();
            }
            if (PatchType.Merge$.MODULE$.equals(patchType)) {
                return MediaType$.MODULE$.application().merge$minuspatch$plusjson();
            }
            if (PatchType.StrategicMerge$.MODULE$.equals(patchType)) {
                return MediaType$.MODULE$.unsafeParse("application/strategic-merge-patch+json");
            }
            if (PatchType.ServerSide$.MODULE$.equals(patchType)) {
                return MediaType$.MODULE$.unsafeParse("application/apply-patch+yaml");
            }
            throw new MatchError((Object)patchType);
        };
    }

    private Method methodFor(APIVerb verb) {
        APIVerb aPIVerb = verb;
        if (APIVerb.GET$.MODULE$.equals(aPIVerb)) {
            return Method$.MODULE$.GET();
        }
        if (APIVerb.POST$.MODULE$.equals(aPIVerb)) {
            return Method$.MODULE$.POST();
        }
        if (APIVerb.DELETE$.MODULE$.equals(aPIVerb)) {
            return Method$.MODULE$.DELETE();
        }
        if (APIVerb.PUT$.MODULE$.equals(aPIVerb)) {
            return Method$.MODULE$.PUT();
        }
        if (aPIVerb instanceof APIVerb.PATCH) {
            APIVerb.PATCH pATCH = APIVerb.PATCH$.MODULE$.unapply((APIVerb.PATCH)aPIVerb);
            PatchType patchType = pATCH._1();
            return Method$.MODULE$.PATCH();
        }
        throw new MatchError((Object)aPIVerb);
    }

    private MediaType contentType(APIVerb verb) {
        APIVerb aPIVerb = verb;
        if (aPIVerb instanceof APIVerb.PATCH) {
            PatchType patchType;
            APIVerb.PATCH pATCH = APIVerb.PATCH$.MODULE$.unapply((APIVerb.PATCH)aPIVerb);
            PatchType patchType2 = patchType = pATCH._1();
            return (MediaType)this.mediaTypeFor().apply((Object)patchType2);
        }
        return MediaType$.MODULE$.application().json();
    }

    private static final List cookiesFor$$anonfun$3() {
        return Headers$.MODULE$.empty();
    }
}

