/*
 * Decompiled with CFR 0.152.
 */
package dev.hnaderi.k8s.client.http4s;

import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.std.Env;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.IfFOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import dev.hnaderi.k8s.client.AuthenticationParams;
import dev.hnaderi.k8s.client.AuthenticationParams$;
import dev.hnaderi.k8s.client.Config;
import dev.hnaderi.k8s.client.Config$;
import dev.hnaderi.k8s.client.HttpClient;
import dev.hnaderi.k8s.client.HttpClient$;
import dev.hnaderi.k8s.client.http4s.Http4sBackend$;
import dev.hnaderi.k8s.manifest.package$;
import dev.hnaderi.k8s.utils.Builder;
import dev.hnaderi.k8s.utils.Reader;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.io.file.Files;
import fs2.io.file.Path;
import fs2.io.file.Path$;
import java.io.Serializable;
import org.http4s.EntityDecoder;
import org.http4s.EntityEncoder;
import org.http4s.client.Client;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;

public abstract class Http4sKubernetesClient<F> {
    private final Async<F> F;
    private final Files<F> Files;
    private final Env<F> Env;

    public Http4sKubernetesClient(Async<F> F, Files<F> Files2, Env<F> Env2) {
        this.F = F;
        this.Files = Files2;
        this.Env = Env2;
    }

    public abstract Resource<F, Client<F>> buildClient();

    public final <T> HttpClient<F> fromClient(String baseUrl, Client<F> client, EntityEncoder<F, T> enc, EntityDecoder<F, T> dec, Builder<T> builder, Reader<T> reader) {
        return HttpClient$.MODULE$.streaming(baseUrl, Http4sBackend$.MODULE$.fromClient(client, this.F, enc, dec, builder, reader), HttpClient$.MODULE$.streaming$default$3());
    }

    public final <T> Resource<F, HttpClient<F>> fromUrl(String baseUrl, EntityEncoder<F, T> enc, EntityDecoder<F, T> dec, Builder<T> builder, Reader<T> reader) {
        return this.buildClient().map((Function1 & Serializable)_$2 -> this.fromClient(baseUrl, (Client<F>)_$2, enc, dec, builder, reader));
    }

    public abstract <T> Resource<F, HttpClient<F>> fromConfig(Config var1, Option<String> var2, EntityEncoder<F, T> var3, EntityDecoder<F, T> var4, Builder<T> var5, Reader<T> var6);

    public <T> Option<String> fromConfig$default$2() {
        return None$.MODULE$;
    }

    public abstract <T> Resource<F, HttpClient<F>> from(String var1, Option<Path> var2, Option<Path> var3, Option<Path> var4, Option<String> var5, AuthenticationParams var6, EntityEncoder<F, T> var7, EntityDecoder<F, T> var8, Builder<T> var9, Reader<T> var10);

    public <T> Option<Path> from$default$2() {
        return None$.MODULE$;
    }

    public <T> Option<Path> from$default$3() {
        return None$.MODULE$;
    }

    public <T> Option<Path> from$default$4() {
        return None$.MODULE$;
    }

    public <T> Option<String> from$default$5() {
        return None$.MODULE$;
    }

    public <T> AuthenticationParams from$default$6() {
        return AuthenticationParams$.MODULE$.empty();
    }

    public final <T> Resource<F, HttpClient<F>> load(Path config, Option<String> context, EntityEncoder<F, T> enc, EntityDecoder<F, T> dec, Builder<T> builder, Reader<T> reader) {
        return Resource$.MODULE$.eval(this.Files.readUtf8(config).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.F))).string((.less.colon.less)$less$colon$less$.MODULE$.refl())).flatMap((Function1 & Serializable)str -> Resource$.MODULE$.eval(this.F.fromEither(package$.MODULE$.parse(str, Config$.MODULE$.decoder()))).flatMap((Function1 & Serializable)conf -> this.fromConfig((Config)conf, context, enc, dec, builder, reader).map((Function1 & Serializable)client -> client)));
    }

    public <T> Option<String> load$default$2() {
        return None$.MODULE$;
    }

    public final <T> Resource<F, HttpClient<F>> loadFile(String configFile, Option<String> context, EntityEncoder<F, T> enc, EntityDecoder<F, T> dec, Builder<T> builder, Reader<T> reader) {
        return this.load(Path$.MODULE$.apply(configFile), context, enc, dec, builder, reader);
    }

    public <T> Option<String> loadFile$default$2() {
        return None$.MODULE$;
    }

    public final <T> Resource<F, HttpClient<F>> defaultConfig(EntityEncoder<F, T> enc, EntityDecoder<F, T> dec, Builder<T> builder, Reader<T> reader) {
        return Resource$.MODULE$.eval(this.homeConfig()).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Path value = (Path)((Some)option).value();
                return this.load(value, this.load$default$2(), enc, dec, builder, reader);
            }
            if (None$.MODULE$.equals(option)) {
                return this.podConfig(enc, dec, builder, reader);
            }
            throw new MatchError((Object)option);
        });
    }

    private F homeConfig() {
        return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.Env.get("KUBECONFIG"), this.F).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return this.F.delay(Http4sKubernetesClient::homeConfig$$anonfun$1$$anonfun$1);
            }
            if (option instanceof Some) {
                String value = (String)((Some)option).value();
                Path path = (Path)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Path$.MODULE$.apply(value));
                return ApplicativeIdOps$.MODULE$.pure$extension((Object)path, this.F);
            }
            throw new MatchError((Object)option);
        }), this.F).flatMap((Function1 & Serializable)p -> {
            Object object = package.all$.MODULE$.catsSyntaxIfF(this.Files.exists(p));
            return IfFOps$.MODULE$.ifF$extension(object, () -> Http4sKubernetesClient.homeConfig$$anonfun$2$$anonfun$1(p), Http4sKubernetesClient::homeConfig$$anonfun$2$$anonfun$2, this.F);
        });
    }

    private <T> Resource<F, HttpClient<F>> podConfig(EntityEncoder<F, T> enc, EntityDecoder<F, T> dec, Builder<T> builder, Reader<T> reader) {
        Path base = Path$.MODULE$.apply("/var/run/secrets/kubernetes.io/serviceaccount");
        String apiserver = "https://kubernetes.default.svc";
        Path token = base.$div("token");
        Path caCert = base.$div("ca.crt");
        Resource tokenAuth = Resource$.MODULE$.eval(this.Files.readUtf8(token).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.F))).string((.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1 & Serializable)_$3 -> AuthenticationParams$.MODULE$.bearer(_$3));
        return tokenAuth.flatMap((Function1 & Serializable)auth -> {
            Path path = (Path)package.all$.MODULE$.catsSyntaxOptionId((Object)caCert);
            Option option = OptionIdOps$.MODULE$.some$extension((Object)path);
            Option<Path> option2 = this.from$default$3();
            Option<Path> option3 = this.from$default$4();
            Option<String> option4 = this.from$default$5();
            return this.from(apiserver, (Option<Path>)option, option2, option3, option4, (AuthenticationParams)auth, enc, dec, builder, reader);
        });
    }

    private static final Path homeConfig$$anonfun$1$$anonfun$1() {
        String string = System.getProperty("user.home");
        if (string == null) {
            return Path$.MODULE$.apply("~").$div(".kube").$div("config");
        }
        String value = string;
        return Path$.MODULE$.apply(value).$div(".kube").$div("config");
    }

    private static final Option homeConfig$$anonfun$2$$anonfun$1(Path p$1) {
        return Some$.MODULE$.apply((Object)p$1);
    }

    private static final Option homeConfig$$anonfun$2$$anonfun$2() {
        return None$.MODULE$;
    }
}

