package dev.hnaderi.k8s.client.pointers.io.k8s.api.storage.v1

import dev.hnaderi.k8s.client._

final case class StorageClassPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.storage.v1.StorageClass] {
  def provisioner : Pointer.Plain[String] = Pointer.Plain(currentPath / s"provisioner")
  def mountOptions : ListPointer[String] = ListPointer(currentPath / s"mountOptions")
  def reclaimPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reclaimPolicy")
  def volumeBindingMode : Pointer.Plain[String] = Pointer.Plain(currentPath / s"volumeBindingMode")
  def metadata :  pointers.io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = pointers.io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
  def allowVolumeExpansion : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"allowVolumeExpansion")
  def allowedTopologies : ListPointer[io.k8s.api.core.v1.TopologySelectorTerm] = ListPointer(currentPath / s"allowedTopologies")
  def parameters : MapPointer[String] = MapPointer(currentPath / s"parameters")
}


