package dev.hnaderi.k8s.client.pointers.io.k8s.api.storage.v1

import dev.hnaderi.k8s.client._

final case class CSIStorageCapacityPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.storage.v1.CSIStorageCapacity] {
  def storageClassName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"storageClassName")
  def maximumVolumeSize : Pointer.Plain[io.k8s.apimachinery.pkg.api.resource.Quantity] = Pointer.Plain(currentPath / s"maximumVolumeSize")
  def nodeTopology :  pointers.io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer = pointers.io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer(currentPath / s"nodeTopology")
  def metadata :  pointers.io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = pointers.io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
  def capacity : Pointer.Plain[io.k8s.apimachinery.pkg.api.resource.Quantity] = Pointer.Plain(currentPath / s"capacity")
}


