package dev.hnaderi.k8s.client.pointers.io.k8s.api.events.v1

import dev.hnaderi.k8s.client._

final case class EventPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.events.v1.Event] {
  def eventTime : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = Pointer.Plain(currentPath / s"eventTime")
  def regarding :  pointers.io.k8s.api.core.v1.ObjectReferencePointer = pointers.io.k8s.api.core.v1.ObjectReferencePointer(currentPath / s"regarding")
  def series :  pointers.io.k8s.api.events.v1.EventSeriesPointer = pointers.io.k8s.api.events.v1.EventSeriesPointer(currentPath / s"series")
  def reason : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reason")
  def deprecatedCount : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"deprecatedCount")
  def related :  pointers.io.k8s.api.core.v1.ObjectReferencePointer = pointers.io.k8s.api.core.v1.ObjectReferencePointer(currentPath / s"related")
  def deprecatedFirstTimestamp : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"deprecatedFirstTimestamp")
  def note : Pointer.Plain[String] = Pointer.Plain(currentPath / s"note")
  def reportingController : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reportingController")
  def metadata :  pointers.io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = pointers.io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
  def deprecatedSource :  pointers.io.k8s.api.core.v1.EventSourcePointer = pointers.io.k8s.api.core.v1.EventSourcePointer(currentPath / s"deprecatedSource")
  def `type` : Pointer.Plain[String] = Pointer.Plain(currentPath / s"type")
  def deprecatedLastTimestamp : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"deprecatedLastTimestamp")
  def reportingInstance : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reportingInstance")
  def action : Pointer.Plain[String] = Pointer.Plain(currentPath / s"action")
}


