package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class ReplicationControllerSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.ReplicationControllerSpec] {
  def minReadySeconds : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"minReadySeconds")
  def replicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"replicas")
  def selector : MapPointer[String] = MapPointer(currentPath / s"selector")
  def template :  pointers.io.k8s.api.core.v1.PodTemplateSpecPointer = pointers.io.k8s.api.core.v1.PodTemplateSpecPointer(currentPath / s"template")
}


