package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class PodSecurityContextPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.PodSecurityContext] {
  def fsGroupChangePolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"fsGroupChangePolicy")
  def sysctls : ListPointer[io.k8s.api.core.v1.Sysctl] = ListPointer(currentPath / s"sysctls")
  def fsGroup : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"fsGroup")
  def supplementalGroups : ListPointer[Int] = ListPointer(currentPath / s"supplementalGroups")
  def runAsGroup : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"runAsGroup")
  def seccompProfile :  pointers.io.k8s.api.core.v1.SeccompProfilePointer = pointers.io.k8s.api.core.v1.SeccompProfilePointer(currentPath / s"seccompProfile")
  def windowsOptions :  pointers.io.k8s.api.core.v1.WindowsSecurityContextOptionsPointer = pointers.io.k8s.api.core.v1.WindowsSecurityContextOptionsPointer(currentPath / s"windowsOptions")
  def seLinuxOptions :  pointers.io.k8s.api.core.v1.SELinuxOptionsPointer = pointers.io.k8s.api.core.v1.SELinuxOptionsPointer(currentPath / s"seLinuxOptions")
  def runAsUser : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"runAsUser")
  def runAsNonRoot : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"runAsNonRoot")
}


