package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class NodeConditionPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.NodeCondition] {
  def status : Pointer.Plain[String] = Pointer.Plain(currentPath / s"status")
  def `type` : Pointer.Plain[String] = Pointer.Plain(currentPath / s"type")
  def reason : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reason")
  def lastTransitionTime : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"lastTransitionTime")
  def message : Pointer.Plain[String] = Pointer.Plain(currentPath / s"message")
  def lastHeartbeatTime : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"lastHeartbeatTime")
}


