package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class EndpointAddressPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.EndpointAddress] {
  def ip : Pointer.Plain[String] = Pointer.Plain(currentPath / s"ip")
  def hostname : Pointer.Plain[String] = Pointer.Plain(currentPath / s"hostname")
  def nodeName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"nodeName")
  def targetRef :  pointers.io.k8s.api.core.v1.ObjectReferencePointer = pointers.io.k8s.api.core.v1.ObjectReferencePointer(currentPath / s"targetRef")
}


