package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class ContainerStateTerminatedPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.ContainerStateTerminated] {
  def exitCode : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"exitCode")
  def reason : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reason")
  def startedAt : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"startedAt")
  def message : Pointer.Plain[String] = Pointer.Plain(currentPath / s"message")
  def finishedAt : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"finishedAt")
  def containerID : Pointer.Plain[String] = Pointer.Plain(currentPath / s"containerID")
  def signal : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"signal")
}


