package dev.hnaderi.k8s.client.pointers.io.k8s.api.authorization.v1

import dev.hnaderi.k8s.client._

final case class SubjectAccessReviewSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.authorization.v1.SubjectAccessReviewSpec] {
  def groups : ListPointer[String] = ListPointer(currentPath / s"groups")
  def resourceAttributes :  pointers.io.k8s.api.authorization.v1.ResourceAttributesPointer = pointers.io.k8s.api.authorization.v1.ResourceAttributesPointer(currentPath / s"resourceAttributes")
  def uid : Pointer.Plain[String] = Pointer.Plain(currentPath / s"uid")
  def extra : MapPointer[Seq[String]] = MapPointer(currentPath / s"extra")
  def user : Pointer.Plain[String] = Pointer.Plain(currentPath / s"user")
  def nonResourceAttributes :  pointers.io.k8s.api.authorization.v1.NonResourceAttributesPointer = pointers.io.k8s.api.authorization.v1.NonResourceAttributesPointer(currentPath / s"nonResourceAttributes")
}


