package dev.hnaderi.k8s.client.pointers.io.k8s.api.apps.v1

import dev.hnaderi.k8s.client._

final case class StatefulSetStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.apps.v1.StatefulSetStatus] {
  def replicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"replicas")
  def conditions : ListPointer[io.k8s.api.apps.v1.StatefulSetCondition] = ListPointer(currentPath / s"conditions")
  def collisionCount : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"collisionCount")
  def availableReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"availableReplicas")
  def observedGeneration : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"observedGeneration")
  def currentRevision : Pointer.Plain[String] = Pointer.Plain(currentPath / s"currentRevision")
  def currentReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"currentReplicas")
  def updateRevision : Pointer.Plain[String] = Pointer.Plain(currentPath / s"updateRevision")
  def updatedReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"updatedReplicas")
  def readyReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"readyReplicas")
}


