package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.client._

/** Pointer for NamedResourcesAttribute */
final case class NamedResourcesAttributePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.resource.v1alpha2.NamedResourcesAttribute] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def quantity : Pointer.Plain[io.k8s.apimachinery.pkg.api.resource.Quantity] = Pointer.Plain(currentPath / s"quantity")
  def stringSlice :  io.k8s.api.resource.v1alpha2.NamedResourcesStringSlicePointer = io.k8s.api.resource.v1alpha2.NamedResourcesStringSlicePointer(currentPath / s"stringSlice")
  def string : Pointer.Plain[String] = Pointer.Plain(currentPath / s"string")
  def version : Pointer.Plain[String] = Pointer.Plain(currentPath / s"version")
  def bool : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"bool")
  def intSlice :  io.k8s.api.resource.v1alpha2.NamedResourcesIntSlicePointer = io.k8s.api.resource.v1alpha2.NamedResourcesIntSlicePointer(currentPath / s"intSlice")
  def int : Pointer.Plain[Long] = Pointer.Plain(currentPath / s"int")
}


