package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for NodeStatus */
final case class NodeStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.NodeStatus] {
  def volumesInUse : ListPointer[String] = ListPointer(currentPath / s"volumesInUse")
  def conditions : ListPointer[io.k8s.api.core.v1.NodeCondition] = ListPointer(currentPath / s"conditions")
  def nodeInfo :  io.k8s.api.core.v1.NodeSystemInfoPointer = io.k8s.api.core.v1.NodeSystemInfoPointer(currentPath / s"nodeInfo")
  def volumesAttached : ListPointer[io.k8s.api.core.v1.AttachedVolume] = ListPointer(currentPath / s"volumesAttached")
  def phase : Pointer.Plain[String] = Pointer.Plain(currentPath / s"phase")
  def config :  io.k8s.api.core.v1.NodeConfigStatusPointer = io.k8s.api.core.v1.NodeConfigStatusPointer(currentPath / s"config")
  def allocatable : MapPointer[io.k8s.apimachinery.pkg.api.resource.Quantity] = MapPointer(currentPath / s"allocatable")
  def images : ListPointer[io.k8s.api.core.v1.ContainerImage] = ListPointer(currentPath / s"images")
  def daemonEndpoints :  io.k8s.api.core.v1.NodeDaemonEndpointsPointer = io.k8s.api.core.v1.NodeDaemonEndpointsPointer(currentPath / s"daemonEndpoints")
  def addresses : ListPointer[io.k8s.api.core.v1.NodeAddress] = ListPointer(currentPath / s"addresses")
  def capacity : MapPointer[io.k8s.apimachinery.pkg.api.resource.Quantity] = MapPointer(currentPath / s"capacity")
}


