package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for LimitRangeItem */
final case class LimitRangeItemPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.LimitRangeItem] {
  def `type` : Pointer.Plain[String] = Pointer.Plain(currentPath / s"type")
  def defaultRequest : MapPointer[io.k8s.apimachinery.pkg.api.resource.Quantity] = MapPointer(currentPath / s"defaultRequest")
  def min : MapPointer[io.k8s.apimachinery.pkg.api.resource.Quantity] = MapPointer(currentPath / s"min")
  def maxLimitRequestRatio : MapPointer[io.k8s.apimachinery.pkg.api.resource.Quantity] = MapPointer(currentPath / s"maxLimitRequestRatio")
  def max : MapPointer[io.k8s.apimachinery.pkg.api.resource.Quantity] = MapPointer(currentPath / s"max")
  def default : MapPointer[io.k8s.apimachinery.pkg.api.resource.Quantity] = MapPointer(currentPath / s"default")
}


