package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for ScaleIOPersistentVolumeSource */
final case class ScaleIOPersistentVolumeSourcePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.ScaleIOPersistentVolumeSource] {
  def system : Pointer.Plain[String] = Pointer.Plain(currentPath / s"system")
  def secretRef :  io.k8s.api.core.v1.SecretReferencePointer = io.k8s.api.core.v1.SecretReferencePointer(currentPath / s"secretRef")
  def gateway : Pointer.Plain[String] = Pointer.Plain(currentPath / s"gateway")
  def readOnly : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"readOnly")
  def fsType : Pointer.Plain[String] = Pointer.Plain(currentPath / s"fsType")
  def storagePool : Pointer.Plain[String] = Pointer.Plain(currentPath / s"storagePool")
  def protectionDomain : Pointer.Plain[String] = Pointer.Plain(currentPath / s"protectionDomain")
  def volumeName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"volumeName")
  def sslEnabled : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"sslEnabled")
  def storageMode : Pointer.Plain[String] = Pointer.Plain(currentPath / s"storageMode")
}


