package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for EnvVar */
final case class EnvVarPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.EnvVar] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def value : Pointer.Plain[String] = Pointer.Plain(currentPath / s"value")
  def valueFrom :  io.k8s.api.core.v1.EnvVarSourcePointer = io.k8s.api.core.v1.EnvVarSourcePointer(currentPath / s"valueFrom")
}


