package io.k8s.api.autoscaling.v2beta2

import dev.hnaderi.k8s.client._

/** Pointer for HorizontalPodAutoscalerSpec */
final case class HorizontalPodAutoscalerSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec] {
  def maxReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"maxReplicas")
  def scaleTargetRef :  io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReferencePointer = io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReferencePointer(currentPath / s"scaleTargetRef")
  def minReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"minReplicas")
  def metrics : ListPointer[io.k8s.api.autoscaling.v2beta2.MetricSpec] = ListPointer(currentPath / s"metrics")
  def behavior :  io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorPointer = io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorPointer(currentPath / s"behavior")
}


